# 画面設計書 96-カレンダー作成

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける「カレンダー作成」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は新規勤務カレンダー（Work Schedule）を登録するための入力フォーム画面である。

**業務上の目的・背景**：組織内に新しい勤務カレンダーを追加する際に使用される画面である。勤務カレンダーは従業員の勤務パターンを定義するマスタデータであり、タイムゾーン、1日あたりの勤務時間、フルタイム必要時間、フレックスタイム設定などを含む。異なる勤務形態（通常勤務、フレックス勤務、2週間交代制など）に対応した複数のカレンダーを設定できる。

**画面へのアクセス方法**：カレンダー一覧画面のヘッダー「作成」ボタンをクリック、またはカレンダー一覧画面の空状態からの作成ボタンをクリックしてアクセスする。

**主要な操作・処理内容**：
1. 基本情報の入力（スケジュール名、タイムゾーン、会社）
2. 設定情報の入力（1日あたり時間、フルタイム必要時間）
3. 柔軟性設定の入力（ステータス、2週間カレンダー、フレックスタイム）
4. フォーム送信によるカレンダーデータの保存

**画面遷移**：
- 本画面から遷移可能：カレンダー詳細画面（作成完了後）、カレンダー一覧画面（キャンセル時）
- 本画面に遷移してくる画面：カレンダー一覧画面

**権限による表示制御**：認証済みユーザーのみアクセス可能。作成時に現在のログインユーザーがcreator_idに自動設定される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-015 | カレンダー管理 | 主機能 | 新規カレンダーデータの作成 |

## 画面種別

登録

## URL/ルーティング

`/employees/configurations/calendars/create`

## 画面構成

- ヘッダー部：画面タイトル
- フォーム部（3カラムレイアウト）：
  - 左側2カラム：基本情報セクション、設定セクション
  - 右側1カラム：柔軟性設定セクション
- サブナビゲーション：Configurationsクラスター内のナビゲーション

## 入出力項目

| No | 項目名 | データ型 | 必須 | 最大長 | 説明 | 備考 |
|----|--------|----------|------|--------|------|------|
| 1 | スケジュール名 | テキスト | ○ | 255 | カレンダーの名称 | ヒントアイコン付き |
| 2 | タイムゾーン | 選択 | ○ | - | 適用するタイムゾーン | デフォルト:システムタイムゾーン、検索可能、ヒントアイコン付き |
| 3 | 会社 | 選択 | - | - | 所属会社 | 検索可能 |
| 4 | 1日あたり時間 | 数値 | - | - | 1日の標準勤務時間 | 0-24、デフォルト8、サフィックス「時間」 |
| 5 | フルタイム必要時間 | 数値 | - | - | 週あたりのフルタイム時間 | 0-168、デフォルト40、サフィックス「時間/週」 |
| 6 | ステータス | トグル | - | - | 有効/無効 | デフォルトON |
| 7 | 2週間カレンダー | トグル | - | - | 2週間交代制の有無 | ヒントアイコン付き |
| 8 | フレックスタイム | トグル | - | - | フレックス勤務の有無 | ヒントアイコン付き、ライブ更新 |

## 表示項目

該当なし

## イベント仕様

### 1-フォーム送信（保存）

フォームの保存ボタンを押下すると以下の処理が実行される：
1. バリデーションチェック（必須項目、範囲チェックなど）
2. creator_idに現在のログインユーザーIDを設定（Hiddenフィールド）
3. employees_calendarsテーブルへINSERT
4. 成功通知の表示
5. カレンダー詳細画面へ遷移

### 2-タイムゾーン選択

タイムゾーン選択フィールドでは、PHPのtimezone_identifiers_listから全タイムゾーンが選択可能。デフォルトはシステムのタイムゾーン（date_default_timezone_get）が設定される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | employees_calendars | INSERT | 新規カレンダーデータの登録 |

### テーブル別更新項目詳細

#### employees_calendars

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | timezone | 選択されたタイムゾーン | 必須 |
| INSERT | company_id | 選択された会社ID | |
| INSERT | hours_per_day | フォーム入力値 | デフォルト8 |
| INSERT | full_time_required_hours | フォーム入力値 | デフォルト40 |
| INSERT | is_active | フォーム入力値 | デフォルトtrue |
| INSERT | two_weeks_calendar | フォーム入力値 | boolean |
| INSERT | flexible_hours | フォーム入力値 | boolean |
| INSERT | creator_id | 現在のログインユーザーID | Hiddenフィールド |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | カレンダーを作成しました | 作成成功時 |
| MSG-002 | エラー | 入力内容に誤りがあります | バリデーションエラー時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| バリデーションエラー | 各フィールドにエラーメッセージを表示 |
| 保存失敗 | エラー通知を表示 |
| 権限不足 | アクセス拒否 |

## 備考

- 本画面はFilament PHPのCreateRecordページとして実装されている
- 作成完了後は自動的に詳細画面（ViewCalendar）へリダイレクトされる
- creator_idはHiddenフィールドで自動設定される
- mutateFormDataBeforeSaveメソッドが存在するが、現在は特別な処理を行っていない
- タイムゾーン選択にはPHPのtimezone_identifiers_list()が使用される
- フレックスタイムトグルはlive()で設定されており、他のフィールドとの連動に使用可能
