# 画面設計書 97-カレンダー編集

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける「カレンダー編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は既存の勤務カレンダー（Work Schedule）データを編集するためのフォーム画面である。

**業務上の目的・背景**：登録済みの勤務カレンダー情報を修正・更新する際に使用される画面である。勤務時間の変更、タイムゾーンの調整、フレックスタイム設定の変更など、組織の勤務体制の変更に対応する。勤務カレンダーは従業員の勤怠管理の基盤となるため、適切な更新が重要である。

**画面へのアクセス方法**：カレンダー一覧画面の行アクションから「編集」を選択、またはカレンダー詳細画面のヘッダーから「編集」ボタンをクリックしてアクセスする。

**主要な操作・処理内容**：
1. 既存カレンダーデータの表示・確認
2. 基本情報の編集（スケジュール名、タイムゾーン、会社）
3. 設定情報の編集（1日あたり時間、フルタイム必要時間）
4. 柔軟性設定の編集（ステータス、2週間カレンダー、フレックスタイム）
5. フォーム送信によるカレンダーデータの更新
6. カレンダーの削除

**画面遷移**：
- 本画面から遷移可能：カレンダー詳細画面（保存完了後）、カレンダー一覧画面（削除後）
- 本画面に遷移してくる画面：カレンダー一覧画面、カレンダー詳細画面

**権限による表示制御**：認証済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-015 | カレンダー管理 | 主機能 | 既存カレンダーデータの編集・削除 |

## 画面種別

編集

## URL/ルーティング

`/employees/configurations/calendars/{record}/edit`

## 画面構成

- ヘッダー部：画面タイトル、表示ボタン、削除ボタン
- フォーム部（3カラムレイアウト）：
  - 左側2カラム：基本情報セクション、設定セクション
  - 右側1カラム：柔軟性設定セクション
- サブナビゲーション：Configurationsクラスター内のナビゲーション

## 入出力項目

| No | 項目名 | データ型 | 必須 | 最大長 | 説明 | 備考 |
|----|--------|----------|------|--------|------|------|
| 1 | スケジュール名 | テキスト | ○ | 255 | カレンダーの名称 | ヒントアイコン付き |
| 2 | タイムゾーン | 選択 | ○ | - | 適用するタイムゾーン | 検索可能、ヒントアイコン付き |
| 3 | 会社 | 選択 | - | - | 所属会社 | 検索可能 |
| 4 | 1日あたり時間 | 数値 | - | - | 1日の標準勤務時間 | 0-24、サフィックス「時間」 |
| 5 | フルタイム必要時間 | 数値 | - | - | 週あたりのフルタイム時間 | 0-168、サフィックス「時間/週」 |
| 6 | ステータス | トグル | - | - | 有効/無効 | |
| 7 | 2週間カレンダー | トグル | - | - | 2週間交代制の有無 | ヒントアイコン付き |
| 8 | フレックスタイム | トグル | - | - | フレックス勤務の有無 | ヒントアイコン付き、ライブ更新 |

## 表示項目

該当なし

## イベント仕様

### 1-フォーム送信（保存）

フォームの保存ボタンを押下すると以下の処理が実行される：
1. バリデーションチェック（必須項目、範囲チェックなど）
2. employees_calendarsテーブルへUPDATE
3. 成功通知の表示
4. カレンダー詳細画面へ遷移

### 2-表示ボタン押下

ヘッダーの表示ボタンを押下すると、該当カレンダーの詳細画面に遷移する。

### 3-削除ボタン押下

ヘッダーの削除ボタンを押下すると以下の処理が実行される：
1. 確認ダイアログの表示
2. 確認後、論理削除（deleted_atに現在日時を設定）
3. 成功通知の表示
4. カレンダー一覧画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | employees_calendars | UPDATE | カレンダーデータの更新 |
| 削除 | employees_calendars | UPDATE | deleted_atカラムを更新（論理削除） |

### テーブル別更新項目詳細

#### employees_calendars

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | timezone | 選択されたタイムゾーン | 必須 |
| UPDATE | company_id | 選択された会社ID | |
| UPDATE | hours_per_day | フォーム入力値 | |
| UPDATE | full_time_required_hours | フォーム入力値 | |
| UPDATE | is_active | フォーム入力値 | boolean |
| UPDATE | two_weeks_calendar | フォーム入力値 | boolean |
| UPDATE | flexible_hours | フォーム入力値 | boolean |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| UPDATE（削除） | deleted_at | 現在日時 | 論理削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | カレンダーを更新しました | 保存成功時 |
| MSG-002 | 成功 | カレンダーを削除しました | 削除成功時 |
| MSG-003 | エラー | 入力内容に誤りがあります | バリデーションエラー時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| レコードなし | 404エラーを表示 |
| バリデーションエラー | 各フィールドにエラーメッセージを表示 |
| 保存失敗 | エラー通知を表示 |
| 権限不足 | アクセス拒否 |

## 備考

- 本画面はFilament PHPのEditRecordページとして実装されている
- 保存完了後は自動的に詳細画面（ViewCalendar）へリダイレクトされる
- ヘッダーにはViewActionとDeleteActionが配置されている
- フォーム定義はカレンダー作成画面と共通（CalendarResource::form()）
- mutateFormDataBeforeSaveメソッドが存在するが、現在は特別な処理を行っていない
