# 画面設計書 98-カレンダー詳細

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける「カレンダー詳細」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は既存の勤務カレンダー（Work Schedule）データの詳細情報を表示するための読み取り専用画面である。

**業務上の目的・背景**：登録済みの勤務カレンダー情報を確認・閲覧する際に使用される画面である。カレンダーの基本情報、設定情報、柔軟性設定を一覧で確認でき、人事担当者や管理者が勤務スケジュールの詳細を把握するために活用される。関連する勤務時間（Attendance）情報も確認可能。

**画面へのアクセス方法**：カレンダー一覧画面の行アクションから「表示」を選択、カレンダー作成画面での作成完了後、またはカレンダー編集画面での保存完了後にアクセスする。

**主要な操作・処理内容**：
1. 基本情報の表示（スケジュール名、タイムゾーン、会社）
2. 設定情報の表示（1日あたり時間、フルタイム必要時間）
3. 柔軟性設定の表示（ステータス、2週間カレンダー、フレックスタイム）
4. 関連する勤務時間（Attendance）データの参照
5. 編集画面への遷移
6. カレンダーの削除

**画面遷移**：
- 本画面から遷移可能：カレンダー編集画面、カレンダー一覧画面（削除後）
- 本画面に遷移してくる画面：カレンダー一覧画面、カレンダー作成画面、カレンダー編集画面

**権限による表示制御**：認証済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-015 | カレンダー管理 | 主機能 | カレンダーデータの詳細表示・削除 |

## 画面種別

詳細

## URL/ルーティング

`/employees/configurations/calendars/{record}`

## 画面構成

- ヘッダー部：画面タイトル、編集ボタン、削除ボタン
- 詳細表示部（3カラムレイアウト）：
  - 左側2カラム：基本情報セクション、設定セクション
  - 右側1カラム：柔軟性設定セクション
- リレーションマネージャー：カレンダー勤務時間（Attendance）
- サブナビゲーション：Configurationsクラスター内のナビゲーション

## 入出力項目

該当なし（読み取り専用画面のため）

## 表示項目

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|----------|
| 1 | スケジュール名 | テキスト | カレンダーの名称 | 常に表示 |
| 2 | タイムゾーン | テキスト | 適用タイムゾーン | 常に表示 |
| 3 | 会社名 | テキスト | 所属会社名 | 常に表示 |
| 4 | 1日あたり時間 | 日付 | 1日の標準勤務時間 | 常に表示 |
| 5 | フルタイム必要時間 | 日付 | 週あたりのフルタイム時間 | 常に表示 |
| 6 | ステータス | アイコン | 有効/無効 | 常に表示 |
| 7 | 2週間カレンダー | アイコン | 2週間交代制の有無 | 常に表示 |
| 8 | フレックスタイム | アイコン | フレックス勤務の有無 | 常に表示 |

## イベント仕様

### 1-編集ボタン押下

ヘッダーの編集ボタンを押下すると、該当カレンダーの編集画面に遷移する。

### 2-削除ボタン押下

ヘッダーの削除ボタンを押下すると以下の処理が実行される：
1. 確認ダイアログの表示
2. 確認後、論理削除（deleted_atに現在日時を設定）
3. 成功通知の表示
4. カレンダー一覧画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | employees_calendars | SELECT | カレンダーデータの取得 |
| 詳細表示 | companies | SELECT | 会社データの取得（リレーション） |
| 詳細表示 | employees_calendar_attendances | SELECT | 勤務時間データの取得（リレーション） |
| 削除 | employees_calendars | UPDATE | deleted_atカラムを更新（論理削除） |

### テーブル別更新項目詳細

#### employees_calendars

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | 現在日時 | 論理削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 削除しました | 削除成功時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| レコードなし | 404エラーを表示 |
| 権限不足 | アクセス拒否 |

## 備考

- 本画面はFilament PHPのViewRecordページとして実装されている
- infolist()メソッドで表示項目が定義されている
- ヘッダーにはEditActionとDeleteActionが配置されている
- RelationManagerとしてCalendarAttendanceが設定されており、関連する勤務時間データを表示可能
- 各項目にはアイコンが設定されている（heroicon）
- 値がない場合は「—」プレースホルダが表示される
- レイアウトは3カラム構成：左2カラムに基本情報・設定情報、右1カラムに柔軟性設定
- ステータス、2週間カレンダー、フレックスタイムはIconEntry（boolean）で表示
