# 画面設計書 99-退職理由一覧

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける「退職理由一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は従業員の退職理由（Departure Reason）を一覧表示し、管理するための画面である。

**業務上の目的・背景**：従業員が退職する際の理由を分類・管理するためのマスタデータ管理画面である。退職理由は人事分析や離職率の傾向把握に重要なデータとなる。各退職理由には固有の理由コードが自動生成され、統計や報告に活用される。一般的な退職理由（自己都合、定年、転職、契約満了など）を事前に登録しておくことで、退職処理時の入力を効率化する。

**画面へのアクセス方法**：メインメニューから「従業員」モジュール → 「設定」クラスター → 「退職理由」を選択してアクセスする。

**主要な操作・処理内容**：
1. 退職理由データの一覧表示（名称、作成者、作成日時など）
2. 退職理由の検索・フィルタリング（名称、従業員、作成者による検索）
3. 新規退職理由の作成（ヘッダーアクション・モーダルフォーム）
4. 個別退職理由の表示・編集・削除（インライン編集）
5. 複数退職理由の一括削除
6. ドラッグによる並び替え

**画面遷移**：
- 本画面から遷移可能：なし（モーダル操作のみ）
- 本画面に遷移してくる画面：従業員モジュール設定メニュー

**権限による表示制御**：認証済みユーザーのみアクセス可能。作成時に現在のログインユーザーがcreator_idに自動設定される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-014 | 退職理由管理 | 主機能 | 退職理由の一覧表示、検索、フィルタ、CRUD操作 |

## 画面種別

一覧

## URL/ルーティング

`/employees/configurations/departure-reasons`

## 画面構成

- ヘッダー部：画面タイトル、新規作成ボタン
- テーブル部：退職理由一覧テーブル（検索、フィルタ、ソート、並び替え対応）
- フィルタ部：QueryBuilderによる高度なフィルタ（名称、従業員、作成者、日付）
- アクション部：行アクション（表示・編集・削除）、一括アクション（削除）
- モーダル部：作成・編集用モーダルフォーム

## 入出力項目

| No | 項目名 | データ型 | 必須 | 最大長 | 説明 | 備考 |
|----|--------|----------|------|--------|------|------|
| 1 | 名称 | テキスト | ○ | - | 退職理由の名称 | 作成・編集時に入力 |

## 表示項目

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|----------|
| 1 | ID | 数値 | 退職理由の一意識別子 | デフォルト非表示 |
| 2 | 名称 | テキスト | 退職理由の名称 | 常に表示 |
| 3 | 作成者 | テキスト | 作成したユーザー名 | デフォルト非表示 |
| 4 | 作成日時 | 日時 | レコード作成日時 | デフォルト非表示 |
| 5 | 更新日時 | 日時 | レコード更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「作成」ボタンを押下すると、モーダルフォームが表示される：
1. 名称を入力
2. 保存時にreason_code（名称のCRC32ハッシュ % 100000）が自動生成
3. creator_idに現在のログインユーザーIDが自動設定
4. 保存成功時に通知メッセージを表示

### 2-行クリック（表示）

テーブル行の表示アクションをクリックすると、モーダルで詳細情報が表示される。

### 3-編集アクション

テーブル行の編集アクションをクリックすると、モーダルで編集フォームが表示される。保存時にreason_codeとcreator_idがない場合は自動生成・設定される。

### 4-削除アクション

テーブル行の削除アクションをクリックすると、確認後にレコードが削除される。成功時に通知メッセージが表示される。

### 5-一括削除

テーブル上部の一括アクションから複数選択したレコードを一括で削除する。

### 6-ドラッグ並び替え

テーブル行をドラッグして並び替えることで、sortカラムの値が更新される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | employees_departure_reasons | SELECT | 退職理由データの取得 |
| 作成 | employees_departure_reasons | INSERT | 新規退職理由データの登録 |
| 編集 | employees_departure_reasons | UPDATE | 退職理由データの更新 |
| 削除 | employees_departure_reasons | DELETE | 退職理由データの削除（物理削除） |
| 並び替え | employees_departure_reasons | UPDATE | sortカラムを更新 |

### テーブル別更新項目詳細

#### employees_departure_reasons

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | reason_code | CRC32(name) % 100000 | 自動生成 |
| INSERT | creator_id | 現在のログインユーザーID | 自動設定 |
| INSERT | sort | 自動採番 | SortableTrait |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |
| UPDATE | name | フォーム入力値 | |
| UPDATE | reason_code | 未設定の場合のみ自動生成 | |
| UPDATE | creator_id | 未設定の場合のみ自動設定 | |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| UPDATE（並び替え） | sort | 新しい順序値 | ドラッグ操作時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 退職理由を作成しました | 作成成功時 |
| MSG-002 | 成功 | 退職理由を更新しました | 編集成功時 |
| MSG-003 | 成功 | 退職理由を削除しました | 削除成功時 |
| MSG-004 | 成功 | 退職理由を一括削除しました | 一括削除成功時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| データなし | 空状態表示と新規作成ボタンを表示 |
| 削除失敗 | エラー通知を表示 |
| 権限不足 | アクセス拒否 |

## 備考

- 本画面はFilament PHPのListRecordsページとして実装されている
- 作成・編集・表示はモーダルで行われる（Simple Resource）
- DepartureReasonResourceにはgetPagesでindexのみが定義されている
- テーブルは並び替え可能（reorderable）でsortカラムによる降順がデフォルト
- SoftDeletesは使用されていない（物理削除）
- reason_codeはCRC32ハッシュの剰余で自動生成される一意コード
- フォームはシンプルで、名称のみを入力する構成
