---
generated_at: 2025-12-26 18:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：1-勘定科目一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **アクセス方法の詳細**：ナビゲーション設定が無効のため、実際のアクセス経路の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/AccountResource/Pages/ListAccounts.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/AccountResource.php`
- E-03: `plugins/webkul/accounts/src/Models/Account.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面クラスはListRecordsを継承 | E-01 | ○ |
| C-02 | ヘッダーにCreateActionが存在 | E-01 | ○ |
| C-03 | テーブルにcode列が存在 | E-02 | ○ |
| C-04 | テーブルにname列が存在 | E-02 | ○ |
| C-05 | テーブルにaccount_type列が存在 | E-02 | ○ |
| C-06 | テーブルにcurrency.name列が存在 | E-02 | ○ |
| C-07 | テーブルにdeprecated列が存在 | E-02 | ○ |
| C-08 | テーブルにreconcile列が存在 | E-02 | ○ |
| C-09 | テーブルにnon_trade列が存在 | E-02 | ○ |
| C-10 | 行アクションにView,Edit,Deleteが存在 | E-02 | ○ |
| C-11 | 一括削除アクションが存在 | E-02 | ○ |
| C-12 | モデルはaccounts_accountsテーブルを使用 | E-03 | ○ |
| C-13 | ナビゲーション表示が無効 | E-02 | ○ |
| C-14 | 画面一覧でNo.1として登録 | E-04 | ○ |
| C-15 | 画面へのアクセス方法の詳細経路 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 画面へのアクセス方法について、shouldRegisterNavigation = falseのため、どのメニューからアクセスするかの詳細経路が不明確
  - 候補：会計クラスター設定 / 別リソースからのリンク / 直接URL

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく仕様のため、実装との整合性は高い
- 1: 中リスク - ナビゲーション設定が無効のため、実際のユーザーアクセスパスの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] アクセス経路の確認：どのメニュー/リンクから本画面にアクセスするか
- [ ] 削除時の関連データ処理の確認
- [ ] 権限設定の実装確認
