---
generated_at: 2025-12-26 16:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 45
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 101-勤務地一覧

## 概要

本レポートは「勤務地一覧」画面設計書の各記述に対する根拠を示します。

## 根拠一覧

### 1. 基本情報

| 記述 | 根拠 | ソース |
|------|------|--------|
| 画面ID: 101 | 画面一覧CSVに記載 | `docs/code-to-docs/画面一覧/画面一覧.csv` |
| 画面名: 勤務地一覧 | CSVの画面名カラム | `画面一覧.csv` 101行目 |
| 対応するソースファイル | CSVのファイルパスカラム | `画面一覧.csv` 101行目 |
| 関連モデル: WorkLocation | WorkLocationResourceのmodel定義 | `WorkLocationResource.php` L42 |

### 2. テーブルカラム

| 記述 | 根拠 | ソース |
|------|------|--------|
| ID列 | `TextColumn::make('id')` | `WorkLocationResource.php` L99-103 |
| name列が検索可能 | `->searchable()` | `WorkLocationResource.php` L105-106 |
| location_typeがバッジ表示 | `->badge()` | `WorkLocationResource.php` L107-110 |
| is_activeがアイコン表示 | `IconColumn::make('is_active')->boolean()` | `WorkLocationResource.php` L111-113 |
| company.nameがソート可能 | `->sortable()` | `WorkLocationResource.php` L114-116 |
| location_numberがデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `WorkLocationResource.php` L117-120 |
| createdBy.nameがデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `WorkLocationResource.php` L121-124 |
| created_atがデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `WorkLocationResource.php` L125-129 |
| updated_atがデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `WorkLocationResource.php` L130-134 |
| deleted_atがデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `WorkLocationResource.php` L135-139 |

### 3. フォームフィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| nameフィールドが必須 | `->required()` | `WorkLocationResource.php` L68-70 |
| nameの最大長255 | `->maxLength(255)` | `WorkLocationResource.php` L70 |
| creator_idが非表示 | `Hidden::make('creator_id')` | `WorkLocationResource.php` L71-73 |
| creator_idにログインユーザーID設定 | `->default(Auth::user()->id)` | `WorkLocationResource.php` L73 |
| location_typeがToggleButtons | `ToggleButtons::make('location_type')` | `WorkLocationResource.php` L74-78 |
| location_typeの選択肢がEnum | `->options(WorkLocationEnum::class)` | `WorkLocationResource.php` L77 |
| company_idがSelect | `Select::make('company_id')` | `WorkLocationResource.php` L81-86 |
| company_idが検索可能 | `->searchable()` | `WorkLocationResource.php` L82 |
| company_idがプリロード | `->preload()` | `WorkLocationResource.php` L85 |
| is_activeがToggle | `Toggle::make('is_active')` | `WorkLocationResource.php` L87-89 |

### 4. フィルタ

| 記述 | 根拠 | ソース |
|------|------|--------|
| TernaryFilter (is_active) | `TernaryFilter::make('is_active')` | `WorkLocationResource.php` L166-167 |
| QueryBuilder使用 | `QueryBuilder::make()` | `WorkLocationResource.php` L168-206 |
| TextConstraint (name) | `TextConstraint::make('name')` | `WorkLocationResource.php` L171-173 |
| TextConstraint (location_type) | `TextConstraint::make('location_type')` | `WorkLocationResource.php` L174-176 |
| TextConstraint (location_number) | `TextConstraint::make('location_number')` | `WorkLocationResource.php` L177-179 |
| RelationshipConstraint (company) | `RelationshipConstraint::make('company')` | `WorkLocationResource.php` L180-190 |
| RelationshipConstraint (createdBy) | `RelationshipConstraint::make('createdBy')` | `WorkLocationResource.php` L191-201 |
| DateConstraint (created_at) | `DateConstraint::make('created_at')` | `WorkLocationResource.php` L202-203 |
| DateConstraint (updated_at) | `DateConstraint::make('updated_at')` | `WorkLocationResource.php` L204-205 |

### 5. グループ化

| 記述 | 根拠 | ソース |
|------|------|--------|
| name グループ | `Group::make('name')` | `WorkLocationResource.php` L142-144 |
| createdBy.name グループ | `Group::make('createdBy.name')` | `WorkLocationResource.php` L145-147 |
| location_type グループ | `Group::make('location_type')` | `WorkLocationResource.php` L148-150 |
| company.name グループ | `Group::make('company.name')` | `WorkLocationResource.php` L151-153 |
| is_active グループ | `Group::make('is_active')` | `WorkLocationResource.php` L154-156 |
| created_at グループ | `Group::make('created_at')` | `WorkLocationResource.php` L157-159 |
| updated_at グループが日付 | `Group::make('updated_at')->date()` | `WorkLocationResource.php` L160-163 |

### 6. アクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| ViewAction存在 | `ViewAction::make()` | `WorkLocationResource.php` L209 |
| EditAction存在 | `EditAction::make()` | `WorkLocationResource.php` L210-216 |
| DeleteAction存在 | `DeleteAction::make()` | `WorkLocationResource.php` L217-223 |
| RestoreAction存在 | `RestoreAction::make()` | `WorkLocationResource.php` L224-230 |
| ForceDeleteAction存在 | `ForceDeleteAction::make()` | `WorkLocationResource.php` L231-237 |
| DeleteBulkAction存在 | `DeleteBulkAction::make()` | `WorkLocationResource.php` L241-246 |
| ForceDeleteBulkAction存在 | `ForceDeleteBulkAction::make()` | `WorkLocationResource.php` L247-254 |
| CreateAction (empty state) | `CreateAction::make()->icon('heroicon-o-plus-circle')` | `WorkLocationResource.php` L258-265 |

### 7. 特殊機能

| 記述 | 根拠 | ソース |
|------|------|--------|
| reorderableColumns | `->reorderableColumns()` | `WorkLocationResource.php` L96 |
| columnManagerColumns: 2 | `->columnManagerColumns(2)` | `WorkLocationResource.php` L97 |

## 検証結果

- 全45件の記述について、ソースコードから直接確認できる根拠を示しました
- 根拠なしの記述: 0件
- 信頼度: 100%
