---
generated_at: 2025-12-26 16:32:00
metrics:
  claims_total: 38
  claims_with_evidence: 38
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 102-雇用形態一覧

## 概要

本レポートは「雇用形態一覧」画面設計書の各記述に対する根拠を示します。

## 根拠一覧

### 1. 基本情報

| 記述 | 根拠 | ソース |
|------|------|--------|
| 画面ID: 102 | 画面一覧CSVに記載 | `docs/code-to-docs/画面一覧/画面一覧.csv` |
| 画面名: 雇用形態一覧 | CSVの画面名カラム | `画面一覧.csv` 102行目 |
| 関連モデル: EmploymentType | EmploymentTypeResourceのmodel定義 | `EmploymentTypeResource.php` L33 |
| ナビゲーションアイコン | `protected static string|\BackedEnum|null $navigationIcon = 'heroicon-o-cube-transparent'` | `EmploymentTypeResource.php` L35 |

### 2. テーブルカラム

| 記述 | 根拠 | ソース |
|------|------|--------|
| ID列が検索・ソート可能 | `->searchable()->sortable()` | `EmploymentTypeResource.php` L80-84 |
| ID列がデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `EmploymentTypeResource.php` L84 |
| name列がソート・検索可能 | `->sortable()->searchable()` | `EmploymentTypeResource.php` L85-88 |
| code列がソート・検索可能 | `->sortable()->searchable()` | `EmploymentTypeResource.php` L89-92 |
| country.name列がソート・検索可能 | `->sortable()->searchable()` | `EmploymentTypeResource.php` L93-96 |
| createdBy.name列がデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `EmploymentTypeResource.php` L97-100 |
| created_at列がデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `EmploymentTypeResource.php` L101-105 |
| updated_at列がデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `EmploymentTypeResource.php` L106-110 |

### 3. フォームフィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| creator_idが非表示でデフォルト設定 | `Hidden::make('creator_id')->default(Auth::user()->id)` | `EmploymentTypeResource.php` L58-59 |
| nameフィールドが必須 | `->required()` | `EmploymentTypeResource.php` L61-62 |
| nameの最大長255 | `->maxLength(255)` | `EmploymentTypeResource.php` L63 |
| nameがライブ入力 | `->live(onBlur: true)` | `EmploymentTypeResource.php` L64 |
| country_idがSelect | `Select::make('country_id')` | `EmploymentTypeResource.php` L67-71 |
| country_idが検索可能・プリロード | `->searchable()->preload()` | `EmploymentTypeResource.php` L68-69 |
| フォームが2カラム | `->columns(2)` | `EmploymentTypeResource.php` L73 |

### 4. フィルタ

| 記述 | 根拠 | ソース |
|------|------|--------|
| QueryBuilder使用 | `QueryBuilder::make()` | `EmploymentTypeResource.php` L113-145 |
| constraintPickerColumns: 2 | `->constraintPickerColumns(2)` | `EmploymentTypeResource.php` L114 |
| TextConstraint (name) | `TextConstraint::make('name')` | `EmploymentTypeResource.php` L116-118 |
| RelationshipConstraint (country) | `RelationshipConstraint::make('country')` | `EmploymentTypeResource.php` L119-129 |
| RelationshipConstraint (createdBy) | `RelationshipConstraint::make('createdBy')` | `EmploymentTypeResource.php` L130-140 |
| DateConstraint (created_at) | `DateConstraint::make('created_at')` | `EmploymentTypeResource.php` L141-142 |
| DateConstraint (updated_at) | `DateConstraint::make('updated_at')` | `EmploymentTypeResource.php` L143-144 |

### 5. グループ化

| 記述 | 根拠 | ソース |
|------|------|--------|
| name グループ | `Group::make('name')` | `EmploymentTypeResource.php` L148-150 |
| code グループ | `Group::make('code')` | `EmploymentTypeResource.php` L151-153 |
| country.name グループ | `Group::make('country.name')` | `EmploymentTypeResource.php` L154-156 |
| createdBy.name グループ | `Group::make('createdBy.name')` | `EmploymentTypeResource.php` L157-159 |
| created_at グループ | `Group::make('created_at')` | `EmploymentTypeResource.php` L160-162 |
| updated_at グループが日付 | `Group::make('updated_at')->date()` | `EmploymentTypeResource.php` L163-166 |

### 6. アクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| ViewAction存在 | `ViewAction::make()` | `EmploymentTypeResource.php` L169 |
| EditAction存在 | `EditAction::make()` | `EmploymentTypeResource.php` L170-181 |
| 編集時のmutateDataUsing | `->mutateDataUsing(function (array $data)` | `EmploymentTypeResource.php` L171-175 |
| DeleteAction存在 | `DeleteAction::make()` | `EmploymentTypeResource.php` L182-188 |
| DeleteBulkAction存在 | `DeleteBulkAction::make()` | `EmploymentTypeResource.php` L192-198 |
| CreateAction (empty state) | `CreateAction::make()->icon('heroicon-o-plus-circle')` | `EmploymentTypeResource.php` L202-209 |

### 7. 特殊機能

| 記述 | 根拠 | ソース |
|------|------|--------|
| reorderable: sort | `->reorderable('sort')` | `EmploymentTypeResource.php` L211 |
| デフォルトソート: sort DESC | `->defaultSort('sort', 'desc')` | `EmploymentTypeResource.php` L212 |

### 8. 詳細表示

| 記述 | 根拠 | ソース |
|------|------|--------|
| name表示 | `TextEntry::make('name')` | `EmploymentTypeResource.php` L219-222 |
| code表示 | `TextEntry::make('code')` | `EmploymentTypeResource.php` L223-226 |
| country.name表示 | `TextEntry::make('country.name')` | `EmploymentTypeResource.php` L227-230 |

## 検証結果

- 全38件の記述について、ソースコードから直接確認できる根拠を示しました
- 根拠なしの記述: 0件
- 信頼度: 100%
