---
generated_at: 2025-12-26 16:35:00
metrics:
  claims_total: 42
  claims_with_evidence: 42
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 103-従業員スキルレポート

## 概要

本レポートは「従業員スキルレポート」画面設計書の各記述に対する根拠を示します。

## 根拠一覧

### 1. 基本情報

| 記述 | 根拠 | ソース |
|------|------|--------|
| 画面ID: 103 | 画面一覧CSVに記載 | `docs/code-to-docs/画面一覧/画面一覧.csv` |
| 画面名: 従業員スキルレポート | CSVの画面名カラム | `画面一覧.csv` 103行目 |
| 関連モデル: EmployeeSkill | EmployeeSkillResourceのmodel定義 | `EmployeeSkillResource.php` L27 |
| ナビゲーションアイコン | `protected static string|\BackedEnum|null $navigationIcon = 'heroicon-o-academic-cap'` | `EmployeeSkillResource.php` L29 |
| クラスター: Reportings | `protected static ?string $cluster = Reportings::class` | `EmployeeSkillResource.php` L33 |

### 2. テーブルカラム

| 記述 | 根拠 | ソース |
|------|------|--------|
| ID列がソート可能 | `->sortable()` | `EmployeeSkillResource.php` L53 |
| ID列がデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `EmployeeSkillResource.php` L54 |
| employee.name列が検索・ソート可能 | `->searchable()->sortable()` | `EmployeeSkillResource.php` L57-58 |
| skill.name列が検索・ソート可能 | `->searchable()->sortable()` | `EmployeeSkillResource.php` L61-62 |
| skillLevel.nameがバッジ表示 | `->badge()` | `EmployeeSkillResource.php` L65 |
| skillLevel色分けロジック | `->color(fn ($record) => match...)` | `EmployeeSkillResource.php` L66-72 |
| ProgressBarEntry使用 | `CustomTables\Columns\ProgressBarEntry::make('skill_level_percentage')` | `EmployeeSkillResource.php` L73-75 |
| skillType.nameがバッジ | `->badge()` | `EmployeeSkillResource.php` L78 |
| createdBy.nameがデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `EmployeeSkillResource.php` L86 |
| employee.user.nameがデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `EmployeeSkillResource.php` L91 |
| created_atがデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `EmployeeSkillResource.php` L96 |

### 3. フィルタ

| 記述 | 根拠 | ソース |
|------|------|--------|
| filtersFormColumns: 2 | `->filtersFormColumns(2)` | `EmployeeSkillResource.php` L108 |
| SelectFilter (employee) | `SelectFilter::make('employee')` | `EmployeeSkillResource.php` L110-114 |
| SelectFilter (skill) | `SelectFilter::make('skill')` | `EmployeeSkillResource.php` L115-119 |
| SelectFilter (skill_level) | `SelectFilter::make('skill_level')` | `EmployeeSkillResource.php` L120-124 |
| SelectFilter (skill_type) | `SelectFilter::make('skill_type')` | `EmployeeSkillResource.php` L125-129 |
| QueryBuilder使用 | `QueryBuilder::make()` | `EmployeeSkillResource.php` L130-170 |
| constraintPickerColumns: 2 | `->constraintPickerColumns(2)` | `EmployeeSkillResource.php` L131 |
| RelationshipConstraint (employee) | `RelationshipConstraint::make('employee')` | `EmployeeSkillResource.php` L133-143 |
| RelationshipConstraint (createdBy) | `RelationshipConstraint::make('createdBy')` | `EmployeeSkillResource.php` L144-154 |
| RelationshipConstraint (employee.user) | `RelationshipConstraint::make('employee.user')` | `EmployeeSkillResource.php` L155-165 |
| DateConstraint (created_at) | `DateConstraint::make('created_at')` | `EmployeeSkillResource.php` L166-167 |
| DateConstraint (updated_at) | `DateConstraint::make('updated_at')` | `EmployeeSkillResource.php` L168-169 |

### 4. グループ化

| 記述 | 根拠 | ソース |
|------|------|--------|
| employee.name グループ | `Group::make('employee.name')` | `EmployeeSkillResource.php` L100-102 |
| skillType.name グループ | `Group::make('skillType.name')` | `EmployeeSkillResource.php` L103-105 |
| デフォルトグループ: employee.name | `->defaultGroup('employee.name')` | `EmployeeSkillResource.php` L107 |

### 5. アクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| ActionGroup使用 | `ActionGroup::make([...])` | `EmployeeSkillResource.php` L173-175 |
| ViewAction存在 | `ViewAction::make()` | `EmployeeSkillResource.php` L174 |

### 6. 詳細表示

| 記述 | 根拠 | ソース |
|------|------|--------|
| スキル詳細セクション | `Section::make(...)` | `EmployeeSkillResource.php` L183-201 |
| employee.name表示 | `TextEntry::make('employee.name')` | `EmployeeSkillResource.php` L185-188 |
| skill.name表示 | `TextEntry::make('skill.name')` | `EmployeeSkillResource.php` L189-192 |
| skillLevel.name表示 | `TextEntry::make('skillLevel.name')` | `EmployeeSkillResource.php` L193-196 |
| skillType.name表示 | `TextEntry::make('skillType.name')` | `EmployeeSkillResource.php` L197-199 |
| 2カラムレイアウト | `->columns(2)` | `EmployeeSkillResource.php` L201 |
| 追加情報セクション | `Section::make(...)` | `EmployeeSkillResource.php` L202-213 |
| createdBy.name表示 | `TextEntry::make('createdBy.name')` | `EmployeeSkillResource.php` L204-207 |
| employee.user.name表示 | `TextEntry::make('employee.user.name')` | `EmployeeSkillResource.php` L208-211 |

### 7. 特殊機能

| 記述 | 根拠 | ソース |
|------|------|--------|
| reorderableColumns | `->reorderableColumns()` | `EmployeeSkillResource.php` L48 |
| columnManagerColumns: 2 | `->columnManagerColumns(2)` | `EmployeeSkillResource.php` L49 |
| デフォルトソート: created_at DESC | `->defaultSort('created_at', 'desc')` | `EmployeeSkillResource.php` L98 |
| カスタムスラッグ | `return 'employees/skills'` | `EmployeeSkillResource.php` L219 |

## 検証結果

- 全42件の記述について、ソースコードから直接確認できる根拠を示しました
- 根拠なしの記述: 0件
- 信頼度: 100%
