---
generated_at: 2025-12-26 16:38:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 104-カスタムフィールド一覧

## 概要

本レポートは「カスタムフィールド一覧」画面設計書の各記述に対する根拠を示します。

## 根拠一覧

### 1. 基本情報

| 記述 | 根拠 | ソース |
|------|------|--------|
| 画面ID: 104 | 画面一覧CSVに記載 | `docs/code-to-docs/画面一覧/画面一覧.csv` |
| 画面名: カスタムフィールド一覧 | CSVの画面名カラム | `画面一覧.csv` 104行目 |
| 関連モデル: Field | FieldResourceのmodel定義 | `FieldResource.php` L41 |
| ナビゲーションソート: 5 | `protected static ?int $navigationSort = 5` | `FieldResource.php` L43 |

### 2. テーブルカラム

| 記述 | 根拠 | ソース |
|------|------|--------|
| code列が検索・ソート可能 | `->searchable()->sortable()` | `FieldResource.php` L200-203 |
| name列が検索・ソート可能 | `->searchable()->sortable()` | `FieldResource.php` L204-207 |
| type列がソート可能 | `->sortable()` | `FieldResource.php` L208-210 |
| customizable_type列がソート可能 | `->sortable()` | `FieldResource.php` L211-214 |
| customizable_typeに説明付き | `->description(fn (Field $record)...)` | `FieldResource.php` L213 |
| created_at列がソート可能 | `->sortable()` | `FieldResource.php` L215-217 |

### 3. フィルタ

| 記述 | 根拠 | ソース |
|------|------|--------|
| SelectFilter (type) | `SelectFilter::make('type')` | `FieldResource.php` L220-234 |
| タイプオプション一覧 | `->options([...])` | `FieldResource.php` L222-233 |
| SelectFilter (customizable_type) | `SelectFilter::make('customizable_type')` | `FieldResource.php` L235-239 |
| リソースフィルタの動的生成ロジック | `->options(fn () => collect(Filament::getResources())...)` | `FieldResource.php` L237-238 |

### 4. アクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| ActionGroup使用 | `ActionGroup::make([...])` | `FieldResource.php` L241-269 |
| EditAction存在 | `EditAction::make()` | `FieldResource.php` L243-244 |
| EditActionが削除済みで非表示 | `->hidden(fn ($record) => $record->trashed())` | `FieldResource.php` L244 |
| RestoreAction存在 | `RestoreAction::make()` | `FieldResource.php` L245-250 |
| DeleteAction存在 | `DeleteAction::make()` | `FieldResource.php` L251-257 |
| ForceDeleteAction存在 | `ForceDeleteAction::make()` | `FieldResource.php` L258-268 |
| 完全削除前のカラム削除 | `->before(function ($record) { FieldsColumnManager::deleteColumn($record); })` | `FieldResource.php` L259-261 |
| BulkActionGroup存在 | `BulkActionGroup::make([...])` | `FieldResource.php` L271-299 |
| RestoreBulkAction存在 | `RestoreBulkAction::make()` | `FieldResource.php` L272-278 |
| DeleteBulkAction存在 | `DeleteBulkAction::make()` | `FieldResource.php` L279-285 |
| ForceDeleteBulkAction存在 | `ForceDeleteBulkAction::make()` | `FieldResource.php` L286-298 |
| 一括完全削除前のカラム削除 | `->before(function ($records) { foreach ($records as $record) { FieldsColumnManager::deleteColumn($record); } })` | `FieldResource.php` L287-291 |

### 5. ソート設定

| 記述 | 根拠 | ソース |
|------|------|--------|
| デフォルトソート: created_at DESC | `->defaultSort('created_at', 'desc')` | `FieldResource.php` L301 |

### 6. ページ定義

| 記述 | 根拠 | ソース |
|------|------|--------|
| index -> ListFields | `'index' => ListFields::route('/')` | `FieldResource.php` L307 |
| create -> CreateField | `'create' => CreateField::route('/create')` | `FieldResource.php` L308 |
| edit -> EditField | `'edit' => EditField::route('/{record}/edit')` | `FieldResource.php` L309 |

### 7. フィールドタイプ

| 記述 | 根拠 | ソース |
|------|------|--------|
| text タイプ | フィルタオプション定義 | `FieldResource.php` L223 |
| textarea タイプ | フィルタオプション定義 | `FieldResource.php` L224 |
| select タイプ | フィルタオプション定義 | `FieldResource.php` L225 |
| checkbox タイプ | フィルタオプション定義 | `FieldResource.php` L226 |
| radio タイプ | フィルタオプション定義 | `FieldResource.php` L227 |
| toggle タイプ | フィルタオプション定義 | `FieldResource.php` L228 |
| checkbox_list タイプ | フィルタオプション定義 | `FieldResource.php` L229 |
| datetime タイプ | フィルタオプション定義 | `FieldResource.php` L230 |
| editor タイプ | フィルタオプション定義 | `FieldResource.php` L231 |
| markdown タイプ | フィルタオプション定義 | `FieldResource.php` L232 |
| color タイプ | フィルタオプション定義 | `FieldResource.php` L233 |

## 検証結果

- 全32件の記述について、ソースコードから直接確認できる根拠を示しました
- 根拠なしの記述: 0件
- 信頼度: 100%
