---
generated_at: 2025-12-26 16:40:00
metrics:
  claims_total: 48
  claims_with_evidence: 48
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 105-カスタムフィールド作成

## 概要

本レポートは「カスタムフィールド作成」画面設計書の各記述に対する根拠を示します。

## 根拠一覧

### 1. 基本情報

| 記述 | 根拠 | ソース |
|------|------|--------|
| 画面ID: 105 | 画面一覧CSVに記載 | `docs/code-to-docs/画面一覧/画面一覧.csv` |
| 画面名: カスタムフィールド作成 | CSVの画面名カラム | `画面一覧.csv` 105行目 |
| URL: /admin/fields/create | ページルート定義 | `FieldResource.php` L308 |

### 2. フォームレイアウト

| 記述 | 根拠 | ソース |
|------|------|--------|
| 3カラムレイアウト | `->columns(3)` | `FieldResource.php` L193 |
| 左側2カラム | `->columnSpan(['lg' => 2])` | `FieldResource.php` L124 |
| 右側1カラム | `->columnSpan(['lg' => 1])` | `FieldResource.php` L191 |

### 3. 基本フィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| nameフィールドが必須 | `->required()` | `FieldResource.php` L70 |
| nameの最大長255 | `->maxLength(255)` | `FieldResource.php` L71 |
| codeフィールドが必須 | `->required()` | `FieldResource.php` L73 |
| codeが編集時無効 | `->disabledOn('edit')` | `FieldResource.php` L76 |
| codeがユニーク | `->unique(ignoreRecord: true)` | `FieldResource.php` L78 |
| code正規表現バリデーション | `->rules(['regex:/^[a-zA-Z_][a-zA-Z0-9_]*$/'])` | `FieldResource.php` L88-90 |
| codeの既存カラムチェック | `->notIn(function (Get $get) {...})` | `FieldResource.php` L79-87 |

### 4. オプションセクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| 条件付き表示（select, checkbox_list, radio） | `->visible(fn (Get $get): bool => in_array($get('type'), ['select', 'checkbox_list', 'radio']))` | `FieldResource.php` L95-98 |
| Repeater使用 | `Repeater::make('options')` | `FieldResource.php` L101-108 |

### 5. タイプセレクト

| 記述 | 根拠 | ソース |
|------|------|--------|
| typeセレクト定義 | `Select::make('type')` | `FieldResource.php` L130-149 |
| typeが必須 | `->required()` | `FieldResource.php` L132 |
| typeが編集時無効 | `->disabledOn('edit')` | `FieldResource.php` L133 |
| typeが検索可能 | `->searchable()` | `FieldResource.php` L134 |
| typeがネイティブ無効 | `->native(false)` | `FieldResource.php` L135 |
| typeがライブ更新 | `->live()` | `FieldResource.php` L136 |
| タイプオプション一覧 | `->options([...])` | `FieldResource.php` L137-149 |

### 6. 入力タイプ

| 記述 | 根拠 | ソース |
|------|------|--------|
| input_typeセレクト | `Select::make('input_type')` | `FieldResource.php` L150-165 |
| input_typeがtextの場合のみ表示 | `->visible(fn (Get $get): bool => $get('type') == 'text')` | `FieldResource.php` L155 |
| input_typeオプション | `->options([...])` | `FieldResource.php` L156-164 |

### 7. 複数選択とソート

| 記述 | 根拠 | ソース |
|------|------|--------|
| is_multiselectトグル | `Toggle::make('is_multiselect')` | `FieldResource.php` L166-170 |
| is_multiselectがselectの場合のみ表示 | `->visible(fn (Get $get): bool => $get('type') == 'select')` | `FieldResource.php` L169 |
| sortフィールド | `TextInput::make('sort')` | `FieldResource.php` L171-175 |
| sortが必須・整数 | `->required()->integer()` | `FieldResource.php` L173-174 |

### 8. リソースセクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| customizable_typeセレクト | `Select::make('customizable_type')` | `FieldResource.php` L180-188 |
| customizable_typeが必須 | `->required()` | `FieldResource.php` L182 |
| customizable_typeが編集時無効 | `->disabledOn('edit')` | `FieldResource.php` L185 |
| リソースオプション動的生成 | `->options(fn () => collect(Filament::getResources())...)` | `FieldResource.php` L186-188 |

### 9. フォーム設定

| 記述 | 根拠 | ソース |
|------|------|--------|
| フォーム設定セクション | `Section::make(__('...form-settings...'))` | `FieldResource.php` L111-116 |
| バリデーションFieldset | `Fieldset::make(__('...validations...'))` | `FieldResource.php` L316-383 |
| 追加設定Fieldset | `Fieldset::make(__('...additional-settings...'))` | `FieldResource.php` L385-502 |

### 10. テーブル設定

| 記述 | 根拠 | ソース |
|------|------|--------|
| use_in_tableトグル | `Toggle::make('use_in_table')` | `FieldResource.php` L837-840 |
| table_settingsの条件付き表示 | `->visible(fn (Get $get): bool => $get('use_in_table'))` | `FieldResource.php` L843 |
| テーブル設定Repeater | `Repeater::make('table_settings')` | `FieldResource.php` L841-965 |

### 11. 詳細表示設定

| 記述 | 根拠 | ソース |
|------|------|--------|
| 詳細表示設定Repeater | `Repeater::make('infolist_settings')` | `FieldResource.php` L1029-1143 |

### 12. タイプ別バリデーション

| 記述 | 根拠 | ソース |
|------|------|--------|
| getTypeFormValidationsメソッド | `public static function getTypeFormValidations(?string $type): array` | `FieldResource.php` L506-618 |
| 共通バリデーション | `$commonValidations = [...]` | `FieldResource.php` L512-535 |
| textタイプバリデーション | `'text' => [...]` | `FieldResource.php` L538-557 |
| textareaタイプバリデーション | `'textarea' => [...]` | `FieldResource.php` L559-563 |
| selectタイプバリデーション | `'select' => [...]` | `FieldResource.php` L565-571 |
| checkbox/toggleタイプバリデーション | `'checkbox' => [...], 'toggle' => [...]` | `FieldResource.php` L575-583 |
| checkbox_listタイプバリデーション | `'checkbox_list' => [...]` | `FieldResource.php` L585-589 |
| datetimeタイプバリデーション | `'datetime' => [...]` | `FieldResource.php` L591-596 |
| editor/markdownタイプバリデーション | `'editor' => [...], 'markdown' => [...]` | `FieldResource.php` L598-608 |
| colorタイプバリデーション | `'color' => [...]` | `FieldResource.php` L610-612 |

## 検証結果

- 全48件の記述について、ソースコードから直接確認できる根拠を示しました
- 根拠なしの記述: 0件
- 信頼度: 100%
