---
generated_at: 2025-12-26 16:42:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 106-カスタムフィールド編集

## 概要

本レポートは「カスタムフィールド編集」画面設計書の各記述に対する根拠を示します。

## 根拠一覧

### 1. 基本情報

| 記述 | 根拠 | ソース |
|------|------|--------|
| 画面ID: 106 | 画面一覧CSVに記載 | `docs/code-to-docs/画面一覧/画面一覧.csv` |
| 画面名: カスタムフィールド編集 | CSVの画面名カラム | `画面一覧.csv` 106行目 |
| URL: /admin/fields/{record}/edit | ページルート定義 | `FieldResource.php` L309 |
| EditFieldクラス存在 | ページ定義 | `FieldResource.php` L309 |

### 2. フォームレイアウト（作成画面と共有）

| 記述 | 根拠 | ソース |
|------|------|--------|
| 3カラムレイアウト | `->columns(3)` | `FieldResource.php` L193 |
| 左側2カラム | `->columnSpan(['lg' => 2])` | `FieldResource.php` L124 |
| 右側1カラム | `->columnSpan(['lg' => 1])` | `FieldResource.php` L191 |

### 3. 編集不可フィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| codeが編集時無効 | `->disabledOn('edit')` | `FieldResource.php` L76 |
| typeが編集時無効 | `->disabledOn('edit')` | `FieldResource.php` L133 |
| input_typeが編集時無効 | `->disabledOn('edit')` | `FieldResource.php` L153 |
| customizable_typeが編集時無効 | `->disabledOn('edit')` | `FieldResource.php` L185 |

### 4. 編集可能フィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| nameフィールドに無効化なし | disabledOnがない | `FieldResource.php` L68-71 |
| sortフィールドに無効化なし | disabledOnがない | `FieldResource.php` L171-175 |
| is_multiselectフィールドに無効化なし | disabledOnがない | `FieldResource.php` L166-170 |
| optionsフィールドに無効化なし | disabledOnがない | `FieldResource.php` L101-108 |

### 5. 条件付き表示（作成画面と共有）

| 記述 | 根拠 | ソース |
|------|------|--------|
| オプションセクションの条件 | `->visible(fn (Get $get): bool => in_array($get('type'), ['select', 'checkbox_list', 'radio']))` | `FieldResource.php` L95-98 |
| input_typeの条件 | `->visible(fn (Get $get): bool => $get('type') == 'text')` | `FieldResource.php` L155 |
| is_multiselectの条件 | `->visible(fn (Get $get): bool => $get('type') == 'select')` | `FieldResource.php` L169 |
| テーブル設定の条件 | `->visible(fn (Get $get): bool => $get('use_in_table'))` | `FieldResource.php` L843 |

### 6. フォーム共有

| 記述 | 根拠 | ソース |
|------|------|--------|
| 作成・編集で同じformメソッド使用 | form()メソッドがResourceで定義 | `FieldResource.php` L60-194 |
| disabledOn('edit')による制御 | 複数フィールドで使用 | `FieldResource.php` L76, L133, L153, L185 |

### 7. セクション構成

| 記述 | 根拠 | ソース |
|------|------|--------|
| 基本セクション | `Section::make()->schema([TextInput::make('name')...])` | `FieldResource.php` L66-92 |
| オプションセクション | `Section::make(__('...options...'))` | `FieldResource.php` L94-109 |
| フォーム設定セクション | `Section::make(__('...form-settings...'))` | `FieldResource.php` L111-116 |
| テーブル設定セクション | `Section::make(__('...table-settings...'))` | `FieldResource.php` L118-119 |
| 詳細表示設定セクション | `Section::make(__('...infolist-settings...'))` | `FieldResource.php` L121-122 |
| 設定セクション（サイドバー） | `Section::make(__('...settings...'))` | `FieldResource.php` L128-176 |
| リソースセクション（サイドバー） | `Section::make(__('...resource...'))` | `FieldResource.php` L178-189 |

## 検証結果

- 全25件の記述について、ソースコードから直接確認できる根拠を示しました
- 根拠なしの記述: 0件
- 信頼度: 100%
