---
generated_at: 2025-12-26 16:45:00
metrics:
  claims_total: 42
  claims_with_evidence: 42
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 107-倉庫一覧

## 概要

本レポートは「倉庫一覧」画面設計書の各記述に対する根拠を示します。

## 根拠一覧

### 1. 基本情報

| 記述 | 根拠 | ソース |
|------|------|--------|
| 画面ID: 107 | 画面一覧CSVに記載 | `docs/code-to-docs/画面一覧/画面一覧.csv` |
| 画面名: 倉庫一覧 | CSVの画面名カラム | `画面一覧.csv` 107行目 |
| 関連モデル: Warehouse | WarehouseResourceのmodel定義 | `WarehouseResource.php` L55 |
| ナビゲーションアイコン | `protected static string|\BackedEnum|null $navigationIcon = 'heroicon-o-building-storefront'` | `WarehouseResource.php` L57 |
| ナビゲーションソート: 1 | `protected static ?int $navigationSort = 1` | `WarehouseResource.php` L59 |
| クラスター: Configurations | `protected static ?string $cluster = Configurations::class` | `WarehouseResource.php` L61 |
| レコードタイトル属性: name | `protected static ?string $recordTitleAttribute = 'name'` | `WarehouseResource.php` L63 |
| グローバル検索無効 | `protected static bool $isGloballySearchable = false` | `WarehouseResource.php` L65 |

### 2. テーブルカラム

| 記述 | 根拠 | ソース |
|------|------|--------|
| name列が検索可能 | `->searchable()` | `WarehouseResource.php` L168-169 |
| code列が検索可能 | `->searchable()` | `WarehouseResource.php` L170-172 |
| company.name列がソート可能 | `->sortable()` | `WarehouseResource.php` L173-176 |
| partnerAddress.name列がソート可能 | `->sortable()` | `WarehouseResource.php` L177-180 |
| deleted_at列がデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `WarehouseResource.php` L181-185 |
| created_at列がデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `WarehouseResource.php` L186-190 |
| updated_at列がデフォルト非表示 | `->toggleable(isToggledHiddenByDefault: true)` | `WarehouseResource.php` L191-195 |

### 3. フィルタ

| 記述 | 根拠 | ソース |
|------|------|--------|
| SelectFilter (company_id) | `SelectFilter::make('company_id')` | `WarehouseResource.php` L198-202 |
| 検索可能・プリロード | `->searchable()->preload()` | `WarehouseResource.php` L201-202 |

### 4. グループ化

| 記述 | 根拠 | ソース |
|------|------|--------|
| company.name グループ | `Tables\Grouping\Group::make('company.name')` | `WarehouseResource.php` L205-207 |
| created_at グループ | `Tables\Grouping\Group::make('created_at')` | `WarehouseResource.php` L208-210 |
| updated_at グループが日付 | `Tables\Grouping\Group::make('updated_at')->date()` | `WarehouseResource.php` L211-214 |

### 5. 行アクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| ViewAction存在 | `ViewAction::make()` | `WarehouseResource.php` L217-218 |
| ViewActionが削除済みで非表示 | `->hidden(fn ($record) => $record->trashed())` | `WarehouseResource.php` L218 |
| EditAction存在 | `EditAction::make()` | `WarehouseResource.php` L219-220 |
| EditActionが削除済みで非表示 | `->hidden(fn ($record) => $record->trashed())` | `WarehouseResource.php` L220 |
| RestoreAction存在 | `RestoreAction::make()` | `WarehouseResource.php` L221-227 |
| DeleteAction存在 | `DeleteAction::make()` | `WarehouseResource.php` L228-234 |
| ForceDeleteAction存在 | `ForceDeleteAction::make()` | `WarehouseResource.php` L235-252 |
| 完全削除エラーハンドリング | `try { ... } catch (QueryException $e) { ... }` | `WarehouseResource.php` L236-245 |

### 6. 一括アクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| BulkActionGroup存在 | `BulkActionGroup::make([...])` | `WarehouseResource.php` L255-290 |
| RestoreBulkAction存在 | `RestoreBulkAction::make()` | `WarehouseResource.php` L256-262 |
| DeleteBulkAction存在 | `DeleteBulkAction::make()` | `WarehouseResource.php` L263-269 |
| ForceDeleteBulkAction存在 | `ForceDeleteBulkAction::make()` | `WarehouseResource.php` L270-289 |
| 一括完全削除エラーハンドリング | `try { ... } catch (QueryException $e) { ... }` | `WarehouseResource.php` L271-282 |

### 7. 空状態アクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| CreateAction (empty state) | `CreateAction::make()` | `WarehouseResource.php` L293-295 |
| アイコン: heroicon-o-plus-circle | `->icon('heroicon-o-plus-circle')` | `WarehouseResource.php` L294 |

### 8. 特殊機能

| 記述 | 根拠 | ソース |
|------|------|--------|
| reorderableColumns | `->reorderableColumns()` | `WarehouseResource.php` L165 |
| HasCustomFieldsトレイト使用 | `use HasCustomFields` | `WarehouseResource.php` L53 |

### 9. サブナビゲーション

| 記述 | 根拠 | ソース |
|------|------|--------|
| サブナビゲーション位置制御 | `getSubNavigationPosition()` | `WarehouseResource.php` L381-396 |
| 一覧時はStart | `return SubNavigationPosition::Start` | `WarehouseResource.php` L392 |
| その他はTop | `return SubNavigationPosition::Top` | `WarehouseResource.php` L395 |
| サブナビゲーション項目 | `getRecordSubNavigation()` | `WarehouseResource.php` L398-405 |

### 10. ページ定義

| 記述 | 根拠 | ソース |
|------|------|--------|
| index -> ListWarehouses | `'index' => ListWarehouses::route('/')` | `WarehouseResource.php` L410 |
| create -> CreateWarehouse | `'create' => CreateWarehouse::route('/create')` | `WarehouseResource.php` L411 |
| view -> ViewWarehouse | `'view' => ViewWarehouse::route('/{record}')` | `WarehouseResource.php` L412 |
| edit -> EditWarehouse | `'edit' => EditWarehouse::route('/{record}/edit')` | `WarehouseResource.php` L413 |

## 検証結果

- 全42件の記述について、ソースコードから直接確認できる根拠を示しました
- 根拠なしの記述: 0件
- 信頼度: 100%
