---
generated_at: 2025-12-26 16:48:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 108-倉庫作成

## 概要

本レポートは「倉庫作成」画面設計書の各記述に対する根拠を示します。

## 根拠一覧

### 1. 基本情報

| 記述 | 根拠 | ソース |
|------|------|--------|
| 画面ID: 108 | 画面一覧CSVに記載 | `docs/code-to-docs/画面一覧/画面一覧.csv` |
| 画面名: 倉庫作成 | CSVの画面名カラム | `画面一覧.csv` 108行目 |
| URL: /create | ページルート定義 | `WarehouseResource.php` L411 |

### 2. フォームレイアウト

| 記述 | 根拠 | ソース |
|------|------|--------|
| 3カラムレイアウト | `->columns(3)` | `WarehouseResource.php` L159 |
| 左側2カラム | `->columnSpan(['lg' => 2])` | `WarehouseResource.php` L124 |
| 右側1カラム | `->columnSpan(['lg' => 1])` | `WarehouseResource.php` L156 |

### 3. 基本フィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| nameフィールドが必須 | `->required()` | `WarehouseResource.php` L87 |
| nameの最大長255 | `->maxLength(255)` | `WarehouseResource.php` L88 |
| nameがオートフォーカス | `->autofocus()` | `WarehouseResource.php` L89 |
| nameにプレースホルダー | `->placeholder(...)` | `WarehouseResource.php` L90 |
| nameにスタイル設定 | `->extraInputAttributes(['style' => 'font-size: 1.5rem;height: 3rem;'])` | `WarehouseResource.php` L91 |
| nameがユニーク | `->unique(ignoreRecord: true)` | `WarehouseResource.php` L92 |
| codeフィールドが必須 | `->required()` | `WarehouseResource.php` L96 |
| codeの最大長255 | `->maxLength(255)` | `WarehouseResource.php` L97 |
| codeにプレースホルダー | `->placeholder(...)` | `WarehouseResource.php` L98 |
| codeにヒントツールチップ | `->hintIcon('heroicon-m-question-mark-circle', tooltip: ...)` | `WarehouseResource.php` L99 |
| codeがユニーク | `->unique(ignoreRecord: true)` | `WarehouseResource.php` L100 |

### 4. 会社フィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| company_idセレクト | `Select::make('company_id')` | `WarehouseResource.php` L104-109 |
| company_idが必須 | `->required()` | `WarehouseResource.php` L107 |
| company_idの無効化条件 | `->disabled(fn () => Auth::user()->default_company_id)` | `WarehouseResource.php` L108 |
| company_idのデフォルト値 | `->default(Auth::user()->default_company_id)` | `WarehouseResource.php` L109 |

### 5. 住所フィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| partner_address_idセレクト | `Select::make('partner_address_id')` | `WarehouseResource.php` L110-115 |
| 検索可能 | `->searchable()` | `WarehouseResource.php` L113 |
| プリロード | `->preload()` | `WarehouseResource.php` L114 |
| 作成オプション付き | `->createOptionForm(fn (Schema $schema): Schema => PartnerResource::form($schema))` | `WarehouseResource.php` L115 |

### 6. 設定セクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| 設定セクション全体の表示条件 | `->visible(static::getWarehouseSettings()->enable_multi_steps_routes)` | `WarehouseResource.php` L157 |
| reception_stepsラジオ | `Radio::make('reception_steps')` | `WarehouseResource.php` L132-136 |
| reception_stepsのデフォルト | `->default(ReceptionStep::ONE_STEP)` | `WarehouseResource.php` L135 |
| delivery_stepsラジオ | `Radio::make('delivery_steps')` | `WarehouseResource.php` L138-142 |
| delivery_stepsのデフォルト | `->default(DeliveryStep::ONE_STEP)` | `WarehouseResource.php` L141 |
| 出荷管理フィールドセットの表示条件 | `->visible(static::getWarehouseSettings()->enable_multi_steps_routes)` | `WarehouseResource.php` L145 |

### 7. 補充管理

| 記述 | 根拠 | ソース |
|------|------|--------|
| supplierWarehousesチェックボックスリスト | `CheckboxList::make('supplierWarehouses')` | `WarehouseResource.php` L149-151 |
| 補充管理フィールドセットの表示条件 | `->visible(Warehouse::count() > 1)` | `WarehouseResource.php` L153 |

### 8. カスタムフィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| 追加情報セクション | `Section::make(__('...additional...'))->visible(! empty($customFormFields = static::getCustomFormFields()))` | `WarehouseResource.php` L120-122 |

### 9. 倉庫設定取得

| 記述 | 根拠 | ソース |
|------|------|--------|
| getWarehouseSettingsメソッド | `static public function getWarehouseSettings(): WarehouseSettings` | `WarehouseResource.php` L376-379 |
| onceでキャッシュ | `return once(fn () => app(WarehouseSettings::class))` | `WarehouseResource.php` L378 |

## 検証結果

- 全35件の記述について、ソースコードから直接確認できる根拠を示しました
- 根拠なしの記述: 0件
- 信頼度: 100%
