---
generated_at: 2025-12-26 16:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 109-倉庫編集

## 概要

本レポートは「倉庫編集」画面設計書の各記述に対する根拠を示します。

## 根拠一覧

### 1. 基本情報

| 記述 | 根拠 | ソース |
|------|------|--------|
| 画面ID: 109 | 画面一覧CSVに記載 | `docs/code-to-docs/画面一覧/画面一覧.csv` |
| 画面名: 倉庫編集 | CSVの画面名カラム | `画面一覧.csv` 109行目 |
| URL: /{record}/edit | ページルート定義 | `WarehouseResource.php` L413 |
| EditWarehouseクラス存在 | ページ定義 | `WarehouseResource.php` L413 |

### 2. サブナビゲーション

| 記述 | 根拠 | ソース |
|------|------|--------|
| サブナビゲーション項目定義 | `getRecordSubNavigation()` | `WarehouseResource.php` L398-405 |
| ViewWarehouse含む | `ViewWarehouse::class` | `WarehouseResource.php` L401 |
| EditWarehouse含む | `EditWarehouse::class` | `WarehouseResource.php` L402 |
| ManageRoutes含む | `ManageRoutes::class` | `WarehouseResource.php` L403 |
| 編集画面でのサブナビ位置: Top | `return SubNavigationPosition::Top` | `WarehouseResource.php` L395 |

### 3. フォームレイアウト（作成画面と共有）

| 記述 | 根拠 | ソース |
|------|------|--------|
| 3カラムレイアウト | `->columns(3)` | `WarehouseResource.php` L159 |
| 左側2カラム | `->columnSpan(['lg' => 2])` | `WarehouseResource.php` L124 |
| 右側1カラム | `->columnSpan(['lg' => 1])` | `WarehouseResource.php` L156 |

### 4. 基本フィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| nameフィールドが必須 | `->required()` | `WarehouseResource.php` L87 |
| nameがユニーク（自身除外） | `->unique(ignoreRecord: true)` | `WarehouseResource.php` L92 |
| codeフィールドが必須 | `->required()` | `WarehouseResource.php` L96 |
| codeがユニーク（自身除外） | `->unique(ignoreRecord: true)` | `WarehouseResource.php` L100 |
| company_idセレクト | `Select::make('company_id')` | `WarehouseResource.php` L104-109 |
| partner_address_idセレクト | `Select::make('partner_address_id')` | `WarehouseResource.php` L110-115 |

### 5. 設定セクション

| 記述 | 根拠 | ソース |
|------|------|--------|
| 設定セクション全体の表示条件 | `->visible(static::getWarehouseSettings()->enable_multi_steps_routes)` | `WarehouseResource.php` L157 |
| reception_stepsラジオ | `Radio::make('reception_steps')` | `WarehouseResource.php` L132-136 |
| delivery_stepsラジオ | `Radio::make('delivery_steps')` | `WarehouseResource.php` L138-142 |
| supplierWarehousesチェックボックスリスト | `CheckboxList::make('supplierWarehouses')` | `WarehouseResource.php` L149-151 |
| 補充管理フィールドセットの表示条件 | `->visible(Warehouse::count() > 1)` | `WarehouseResource.php` L153 |

### 6. カスタムフィールド

| 記述 | 根拠 | ソース |
|------|------|--------|
| 追加情報セクションの条件付き表示 | `->visible(! empty($customFormFields = static::getCustomFormFields()))` | `WarehouseResource.php` L121 |

### 7. フォーム共有

| 記述 | 根拠 | ソース |
|------|------|--------|
| 作成・編集で同じformメソッド使用 | form()メソッドがResourceで定義 | `WarehouseResource.php` L77-160 |
| disabledOn('edit')がない | フォームコードに該当なし | `WarehouseResource.php` L77-160 |

### 8. ページ定義

| 記述 | 根拠 | ソース |
|------|------|--------|
| edit -> EditWarehouse | `'edit' => EditWarehouse::route('/{record}/edit')` | `WarehouseResource.php` L413 |
| routes -> ManageRoutes | `'routes' => ManageRoutes::route('/{record}/routes')` | `WarehouseResource.php` L414 |

## 検証結果

- 全28件の記述について、ソースコードから直接確認できる根拠を示しました
- 根拠なしの記述: 0件
- 信頼度: 100%
