---
generated_at: 2025-12-26 18:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-現金丸め一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/CashRoundingResource/Pages/ListCashRounding.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/CashRoundingResource.php`
- E-03: `plugins/webkul/accounts/src/Models/CashRounding.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「現金丸め一覧」である | E-04 | ○ |
| C-02 | ファイルパスはListCashRounding.phpである | E-01, E-04 | ○ |
| C-03 | ListRecordsを継承している | E-01 | ○ |
| C-04 | ヘッダーに作成ボタンがある | E-01 (getHeaderActions) | ○ |
| C-05 | 作成ボタンにheroicon-o-plus-circleアイコンがある | E-01 | ○ |
| C-06 | テーブルカラムに名前、丸め戦略、丸め方法、作成者がある | E-02 (table method) | ○ |
| C-07 | 各行にView、Edit、Deleteアクションがある | E-02 (recordActions) | ○ |
| C-08 | 一括削除機能がある | E-02 (toolbarActions, DeleteBulkAction) | ○ |
| C-09 | グループ化機能がある | E-02 (groups) | ○ |
| C-10 | モデルはCashRoundingである | E-02 ($model) | ○ |
| C-11 | テーブル名はaccounts_cash_roundingsである | E-03 ($table) | ○ |
| C-12 | shouldRegisterNavigation = false | E-02 | ○ |
| C-13 | RoundingStrategyとRoundingMethodはEnumで定義されている | E-02 (use statements, formatStateUsing) | ○ |
| C-14 | ルーティングは'/'（index）である | E-02 (getPages) | ○ |
| C-15 | 削除時に成功通知が表示される | E-02 (successNotification) | ○ |
| C-16 | 一括削除時に成功通知が表示される | E-02 (BulkActionGroup successNotification) | ○ |
| C-17 | カラムはsearchable, sortable | E-02 (table columns) | ○ |
| C-18 | 関連機能SCR-ACC-015, FN-ACC-028 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の画面表示と設計書の記載が一致しているか確認
- [ ] URL/ルーティングが実環境と一致するか確認
- [ ] 多言語対応のラベルキーが正しく設定されているか確認
