---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：111-倉庫ルート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource/Pages/ManageRoutes.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RouteResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource.php`
- E-04: `plugins/webkul/inventories/src/Models/Route.php`
- E-05: `plugins/webkul/inventories/database/migrations/2025_01_06_072353_create_inventories_routes_table.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がManageRelatedRecords | E-01 L15 | ○ |
| C-02 | relationshipが'routes' | E-01 L21 | ○ |
| C-03 | WarehouseResourceのサブナビゲーション | E-03 L403-405 | ○ |
| C-04 | URL形式 /warehouses/{record}/routes | E-03 L414 | ○ |
| C-05 | RouteResourceのフォーム・テーブル再利用 | E-01 L31-37 | ○ |
| C-06 | warehouse_selectableをtrue設定 | E-01 L44, L49 | ○ |
| C-07 | creator_id設定処理 | E-01 L51 | ○ |
| C-08 | company_id設定処理 | E-01 L53 | ○ |
| C-09 | 成功通知の表示 | E-01 L57-61 | ○ |
| C-10 | テーブルカラム（name, company.name等） | E-02 L159-180 | ○ |
| C-11 | フォーム項目（name, company_id等） | E-02 L84-153 | ○ |
| C-12 | inventories_routesテーブル | E-04 L26, E-05 L14 | ○ |
| C-13 | フィルター（company_id） | E-02 L182-187 | ○ |
| C-14 | レコードアクション（表示、編集、復元、削除） | E-02 L191-233 | ○ |
| C-15 | 一括アクション（復元、削除、完全削除） | E-02 L235-269 | ○ |
| C-16 | マルチステップルート設定による表示制御 | E-02 L65-72 | ○ |
| C-17 | ナビゲーションアイコン heroicon-o-arrow-path | E-01 L23 | ○ |
| C-18 | ソート機能（reorderable） | E-02 L189 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けされています

## 6) レビュアーチェックリスト（最小）
- [ ] マルチステップルート機能が無効時のアクセス制御が正しいか確認
- [ ] 外部キー制約違反時のエラーハンドリングが適切か確認
