---
generated_at: 2025-12-26 12:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：112-ルート一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RouteResource/Pages/ListRoutes.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RouteResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Route.php`
- E-04: `plugins/webkul/inventories/database/migrations/2025_01_06_072353_create_inventories_routes_table.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がListRecords | E-01 L12-13 | ○ |
| C-02 | URL形式 /routes | E-02 L393 | ○ |
| C-03 | ナビゲーションアイコン heroicon-o-arrow-path | E-02 L55 | ○ |
| C-04 | ナビゲーション順序 3 | E-02 L57 | ○ |
| C-05 | マルチステップルート設定による表示制御 | E-02 L65-72 | ○ |
| C-06 | テーブルカラム（name, company.name等） | E-02 L159-180 | ○ |
| C-07 | フィルター（company_id） | E-02 L182-187 | ○ |
| C-08 | 並び替え機能（reorderable） | E-02 L189 | ○ |
| C-09 | デフォルトソート（sort desc） | E-02 L190 | ○ |
| C-10 | 新規作成ボタンのヘッダーアクション | E-01 L17-38 | ○ |
| C-11 | creator_id設定処理 | E-01 L26 | ○ |
| C-12 | company_id設定処理 | E-01 L28 | ○ |
| C-13 | 作成成功通知 | E-01 L32-36 | ○ |
| C-14 | タブ機能（all, archived） | E-01 L41-51 | ○ |
| C-15 | allタブバッジ（Route::count()） | E-01 L44-45 | ○ |
| C-16 | archivedタブバッジ（onlyTrashed） | E-01 L46-50 | ○ |
| C-17 | 行アクション（表示、編集、復元、削除、完全削除） | E-02 L191-233 | ○ |
| C-18 | 一括アクション | E-02 L235-269 | ○ |
| C-19 | 外部キー制約エラー時のエラー通知 | E-02 L217-225 | ○ |
| C-20 | SoftDeletes使用 | E-03 L19 | ○ |
| C-21 | SortableTrait使用 | E-03 L19, L59-62 | ○ |
| C-22 | inventories_routesテーブル | E-03 L26, E-04 L14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けされています

## 6) レビュアーチェックリスト（最小）
- [ ] マルチステップルート機能が無効時のナビゲーション非表示が正しいか確認
- [ ] 一括削除時の外部キー制約エラーハンドリングが適切か確認
- [ ] ドラッグ&ドロップ並び替え機能の動作確認
