---
generated_at: 2025-12-26 12:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：113-ルート作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RouteResource/Pages/CreateRoute.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RouteResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Route.php`
- E-04: `plugins/webkul/inventories/database/migrations/2025_01_06_072353_create_inventories_routes_table.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がCreateRecord | E-01 L11 | ○ |
| C-02 | URL形式 /routes/create | E-02 L394 | ○ |
| C-03 | SubNavigationPosition::Start | E-01 L15-17 | ○ |
| C-04 | リダイレクト先がview画面 | E-01 L29-31 | ○ |
| C-05 | 成功通知表示 | E-01 L34-39 | ○ |
| C-06 | creator_id設定処理 | E-01 L44 | ○ |
| C-07 | company_id設定処理（デフォルト会社） | E-01 L46 | ○ |
| C-08 | フォーム項目 name（必須、最大255文字） | E-02 L90-96 | ○ |
| C-09 | フォーム項目 company_id（検索可能） | E-02 L97-113 | ○ |
| C-10 | 削除済み会社の表示とdisable処理 | E-02 L102-108 | ○ |
| C-11 | product_category_selectable トグル | E-02 L121-124 | ○ |
| C-12 | product_selectable トグル | E-02 L125-128 | ○ |
| C-13 | packaging_selectable トグル（設定による表示制御） | E-02 L129-133 | ○ |
| C-14 | warehouse_selectable トグル（live更新） | E-02 L137-141 | ○ |
| C-15 | 倉庫マルチセレクト（条件付き表示） | E-02 L142-148 | ○ |
| C-16 | サブナビゲーション生成 | E-01 L20-27 | ○ |
| C-17 | inventories_routesテーブル | E-03 L26, E-04 L14 | ○ |
| C-18 | inventories_route_warehousesテーブル | E-03 L74-77 | ○ |
| C-19 | SortableTrait使用 | E-03 L19 | ○ |
| C-20 | autofocus設定 | E-02 L94 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けされています

## 6) レビュアーチェックリスト（最小）
- [ ] 削除済み会社が正しく選択不可になっているか確認
- [ ] packaging_selectableの表示条件（enable_packagings）が正しいか確認
- [ ] 倉庫マルチセレクトの条件付き表示が正しく動作するか確認
