---
generated_at: 2025-12-26 12:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：115-ルート詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RouteResource/Pages/ViewRoute.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RouteResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Route.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がViewRecord | E-01 L12 | ○ |
| C-02 | URL形式 /{record} | E-02 L395 | ○ |
| C-03 | HasRecordNavigationTabsトレイト使用 | E-01 L14 | ○ |
| C-04 | 削除ヘッダーアクション | E-01 L18-27 | ○ |
| C-05 | 削除成功通知 | E-01 L20-25 | ○ |
| C-06 | infolist定義 | E-02 L277-355 | ○ |
| C-07 | 3カラムレイアウト | E-02 L354 | ○ |
| C-08 | ルート名表示（TextSize::Large, FontWeight::Bold） | E-02 L285-289 | ○ |
| C-09 | 会社名表示 | E-02 L290-292 | ○ |
| C-10 | 適用対象セクション | E-02 L295-328 | ○ |
| C-11 | IconEntry（product_category_selectable等） | E-02 L300-312 | ○ |
| C-12 | warehouse_selectable条件付き表示 | E-02 L316-325 | ○ |
| C-13 | レコード情報セクション | E-02 L335-350 | ○ |
| C-14 | 作成日時表示 | E-02 L337-340 | ○ |
| C-15 | 作成者表示 | E-02 L342-344 | ○ |
| C-16 | 最終更新日時表示 | E-02 L346-349 | ○ |
| C-17 | サブナビゲーション（View, Edit, ManageRules） | E-02 L374-380 | ○ |
| C-18 | 削除済みレコードは表示ボタン非表示 | E-02 L193 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けされています

## 6) レビュアーチェックリスト（最小）
- [ ] 適用対象のアイコン表示が正しいか確認
- [ ] 倉庫リストの条件付き表示が正しいか確認
- [ ] サブナビゲーションの遷移が正しいか確認
