---
generated_at: 2025-12-26 12:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：116-ルートルール管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RouteResource/Pages/ManageRules.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RuleResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RouteResource.php`
- E-04: `plugins/webkul/inventories/src/Models/Rule.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がManageRelatedRecords | E-01 L16 | ○ |
| C-02 | relationshipが'rules' | E-01 L22 | ○ |
| C-03 | URL形式 /{record}/rules | E-03 L397 | ○ |
| C-04 | ナビゲーションアイコン heroicon-o-clipboard-document-check | E-01 L24 | ○ |
| C-05 | RuleResourceのフォーム・テーブル再利用 | E-01 L31-33 | ○ |
| C-06 | テーブルカラム（action, sourceLocation, destinationLocation） | E-01 L39-45 | ○ |
| C-07 | route_id自動設定 | E-01 L51-53 | ○ |
| C-08 | creator_id設定処理 | E-01 L57 | ○ |
| C-09 | company_id設定処理 | E-01 L59 | ○ |
| C-10 | 成功通知表示 | E-01 L63-67 | ○ |
| C-11 | フォーム項目定義（RuleResource参照） | E-02 L84-233 | ○ |
| C-12 | アクション選択肢（RuleAction enum） | E-02 L102-108 | ○ |
| C-13 | オペレーションタイプ選択時のロケーション自動設定 | E-02 L122-128 | ○ |
| C-14 | inventories_rulesテーブル | E-04 L29 | ○ |
| C-15 | SoftDeletes使用 | E-04 L22 | ○ |
| C-16 | route_idフィールド存在 | E-04 L51 | ○ |
| C-17 | サブナビゲーション（RouteResource） | E-03 L374-380 | ○ |
| C-18 | HasRecordNavigationTabsトレイト | E-01 L18 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けされています

## 6) レビュアーチェックリスト（最小）
- [ ] ルートIDの自動設定が正しく動作するか確認
- [ ] オペレーションタイプ選択時のロケーション自動設定が正しいか確認
- [ ] route選択フィールドがManageRules画面で非表示になっているか確認
