---
generated_at: 2025-12-26 12:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：120-パッケージタイプ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/PackageTypeResource/Pages/ViewPackageType.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/PackageTypeResource.php`
- E-03: `plugins/webkul/inventories/src/Models/PackageType.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がViewRecord | E-01 L9 | ○ |
| C-02 | URL形式 /{record} | E-02 L284 | ○ |
| C-03 | ヘッダーアクション EditAction | E-01 L25 | ○ |
| C-04 | infolist定義 | E-02 L187-277 | ○ |
| C-05 | 3カラムレイアウト | E-02 L276 | ○ |
| C-06 | 名称表示（TextSize::Large, FontWeight::Bold） | E-02 L195-199 | ○ |
| C-07 | サイズセクション（3カラムグリッド） | E-02 L201-225 | ○ |
| C-08 | 長さ表示（アイコン、suffix） | E-02 L206-210 | ○ |
| C-09 | 幅表示（アイコン、suffix） | E-02 L212-216 | ○ |
| C-10 | 高さ表示（アイコン、suffix） | E-02 L218-222 | ○ |
| C-11 | 重量情報（2カラムグリッド） | E-02 L228-241 | ○ |
| C-12 | 基本重量表示 | E-02 L230-234 | ○ |
| C-13 | 最大重量表示 | E-02 L236-240 | ○ |
| C-14 | バーコード表示（placeholder） | E-02 L243-246 | ○ |
| C-15 | 会社名表示 | E-02 L248-250 | ○ |
| C-16 | レコード情報セクション | E-02 L257-272 | ○ |
| C-17 | 作成日時・作成者・更新日時表示 | E-02 L259-271 | ○ |
| C-18 | サブナビゲーション生成 | E-01 L11-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けされています

## 6) レビュアーチェックリスト（最小）
- [ ] 数値の単位（cm, kg）が正しく表示されるか確認
- [ ] バーコードがnullの場合のplaceholder表示を確認
- [ ] 編集ボタンから編集画面への遷移を確認
