---
generated_at: 2025-12-26 18:10:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：121-オペレーションタイプ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **画面遷移の詳細パス**：設定クラスタからの遷移パスが推測
  2. **権限制御の詳細**：ポリシー定義ファイルが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/OperationTypeResource/Pages/ListOperationTypes.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/OperationTypeResource.php`
- E-03: `plugins/webkul/inventories/src/Models/OperationType.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | オペレーションタイプ一覧画面である | E-01, E-04 | ○ |
| C-02 | Filament ListRecordsを継承 | E-01 | ○ |
| C-03 | 「すべて」「アーカイブ済み」のタブがある | E-01 (getTabs()) | ○ |
| C-04 | タブにバッジでレコード件数を表示 | E-01 (Tab::make()->badge()) | ○ |
| C-05 | ヘッダーに新規作成ボタンがある | E-01 (getHeaderActions()) | ○ |
| C-06 | 作成時にcreator_idを自動設定 | E-01 (mutateDataUsing) | ○ |
| C-07 | 作成時にcompany_idを自動設定 | E-01 (mutateDataUsing) | ○ |
| C-08 | テーブルに名前、会社、倉庫カラムがある | E-02 (table()) | ○ |
| C-09 | 作成日時、更新日時はトグル可能 | E-02 (toggleable) | ○ |
| C-10 | タイプ、倉庫、会社でフィルタ可能 | E-02 (filters) | ○ |
| C-11 | 倉庫別、タイプ別でグループ化可能 | E-02 (groups) | ○ |
| C-12 | 表示、編集、復元、削除、完全削除アクションがある | E-02 (recordActions) | ○ |
| C-13 | 一括アクション（復元、削除、完全削除）がある | E-02 (toolbarActions) | ○ |
| C-14 | 空状態時に新規作成アクションを表示 | E-02 (emptyStateActions) | ○ |
| C-15 | モデルはOperationType | E-02, E-03 | ○ |
| C-16 | テーブル名はinventories_operation_types | E-03 | ○ |
| C-17 | SoftDeletesを使用 | E-03 (use SoftDeletes) | ○ |
| C-18 | ナビゲーションアイコンはqueue-list | E-02 (navigationIcon) | ○ |
| C-19 | navigationSortは3 | E-02 | ○ |
| C-20 | クラスタはConfigurations | E-02 (cluster) | ○ |
| C-21 | 完全削除時に外部キー制約エラーをハンドリング | E-02 (QueryException catch) | ○ |
| C-22 | 削除済みレコードで表示・編集アクションが非表示 | E-02 (hidden fn) | ○ |
| C-23 | URL/ルーティングは/inventories/configurations/operation-types | E-02 (getPages) | ○ |
| C-24 | 設定クラスタからの遷移 | **根拠なし** | △ |
| C-25 | 権限による表示制御 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 設定クラスタからの具体的なナビゲーション構造（サイドメニュー構成）
  - 候補：Configurationsクラスタの定義ファイル / ナビゲーション設定ファイル
- 権限・ポリシーの詳細定義
  - 候補：PolicyファイルまたはGateの定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能はすべてソースコードで確認済み
- 1: 中リスク - 権限制御の詳細が未確認のため、実際の動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] タブの切り替えが正しく動作するか確認
- [ ] 新規作成時にcreator_id、company_idが正しく設定されるか確認
- [ ] ソフトデリートと復元が正しく動作するか確認
- [ ] 完全削除時の外部キー制約エラーが適切にハンドリングされるか確認
- [ ] フィルタ・グループ化機能が正しく動作するか確認
