---
generated_at: 2025-12-26 18:12:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：122-オペレーションタイプ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **設定クラスタのサブナビゲーション構成**：クラスタの詳細定義が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/OperationTypeResource/Pages/CreateOperationType.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/OperationTypeResource.php`
- E-03: `plugins/webkul/inventories/src/Models/OperationType.php`
- E-04: `plugins/webkul/inventories/src/Enums/OperationType.php`（参照）
- E-05: `plugins/webkul/inventories/src/Enums/ReservationMethod.php`（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Filament CreateRecordを継承 | E-01 | ○ |
| C-02 | 作成後に詳細画面にリダイレクト | E-01 (getRedirectUrl) | ○ |
| C-03 | 成功通知を表示 | E-01 (getCreatedNotification) | ○ |
| C-04 | reservation_methodをAT_CONFIRMに自動設定 | E-01 (mutateFormDataBeforeCreate) | ○ |
| C-05 | creator_idをAuth::id()に自動設定 | E-01 (mutateFormDataBeforeCreate) | ○ |
| C-06 | サブナビゲーションを生成 | E-01 (getSubNavigation) | ○ |
| C-07 | フォームにnameフィールドがある | E-02 (form) | ○ |
| C-08 | typeフィールドでオペレーションタイプを選択 | E-02 (form) | ○ |
| C-09 | sequence_codeフィールドがある | E-02 (form) | ○ |
| C-10 | print_labelトグルがある | E-02 (form) | ○ |
| C-11 | warehouse_idセレクトがある | E-02 (form) | ○ |
| C-12 | reservation_methodラジオがある | E-02 (form) | ○ |
| C-13 | company_idセレクトがある | E-02 (form) | ○ |
| C-14 | return_operation_type_idセレクトがある | E-02 (form) | ○ |
| C-15 | create_backorderセレクトがある | E-02 (form) | ○ |
| C-16 | move_typeセレクトがある（内部移動時） | E-02 (form) | ○ |
| C-17 | use_create_lotsトグルがある | E-02 (form) | ○ |
| C-18 | use_existing_lotsトグルがある | E-02 (form) | ○ |
| C-19 | source_location_idセレクトがある | E-02 (form) | ○ |
| C-20 | destination_location_idセレクトがある | E-02 (form) | ○ |
| C-21 | タイプ変更時にロケーションが自動設定 | E-02 (afterStateUpdated) | ○ |
| C-22 | 倉庫変更時にロケーションが連動 | E-02 (live, afterStateUpdated) | ○ |
| C-23 | 削除済み倉庫が選択不可 | E-02 (disableOptionWhen) | ○ |
| C-24 | 削除済みロケーションが選択不可 | E-02 (disableOptionWhen) | ○ |
| C-25 | トレーサビリティ設定でロット項目表示制御 | E-02 (visible TraceabilitySettings) | ○ |
| C-26 | 倉庫設定でロケーション項目表示制御 | E-02 (visible WarehouseSettings) | ○ |
| C-27 | オペレーション設定でレセプションレポート表示制御 | E-02 (visible OperationSettings) | ○ |
| C-28 | サブナビゲーションでクラスタコンポーネントを表示 | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- Configurationsクラスタの詳細定義（getClusteredComponents）
  - 候補：`plugins/webkul/inventories/src/Filament/Clusters/Configurations.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構成とデータ処理はソースコードで詳細に確認済み
- 0: 低リスク - 動的フィールド表示のロジックも確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] オペレーションタイプ変更時にロケーションが正しく自動設定されるか確認
- [ ] 必須項目のバリデーションが正しく動作するか確認
- [ ] 作成成功後に詳細画面にリダイレクトされるか確認
- [ ] トレーサビリティ設定・倉庫設定によるフィールド表示制御が正しいか確認
- [ ] 削除済み倉庫・ロケーションが選択不可になっているか確認
