---
generated_at: 2025-12-26 18:22:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：125-ルール一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RuleResource/Pages/ListRules.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RuleResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Rule.php`
- E-04: `plugins/webkul/inventories/src/Settings/WarehouseSettings.php`（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルール一覧画面である | E-01, E-02 | ○ |
| C-02 | Filament ListRecordsを継承 | E-01 | ○ |
| C-03 | 「すべて」「アーカイブ済み」のタブがある | E-01 (getTabs()) | ○ |
| C-04 | タブにバッジでレコード件数を表示 | E-01 (Tab::make()->badge()) | ○ |
| C-05 | ヘッダーに新規作成ボタンがある | E-01 (getHeaderActions()) | ○ |
| C-06 | 作成時にcreator_idを自動設定 | E-01 (mutateDataUsing) | ○ |
| C-07 | 作成時にcompany_idを自動設定 | E-01 (mutateDataUsing) | ○ |
| C-08 | テーブルにアクション、ソースロケーション、宛先ロケーション、ルート、名前カラムがある | E-02 (table()) | ○ |
| C-09 | 削除日時、作成日時、更新日時はトグル可能 | E-02 (toggleable) | ○ |
| C-10 | アクション、ソースロケーション、宛先ロケーション、ルートでフィルタ可能 | E-02 (filters) | ○ |
| C-11 | アクション別、ロケーション別、ルート別でグループ化可能 | E-02 (groups) | ○ |
| C-12 | 表示、編集、復元、削除、完全削除アクションがある | E-02 (recordActions) | ○ |
| C-13 | 一括アクション（復元、削除、完全削除）がある | E-02 (toolbarActions) | ○ |
| C-14 | 空状態時に新規作成アクションを表示 | E-02 (emptyStateActions) | ○ |
| C-15 | モデルはRule | E-02, E-03 | ○ |
| C-16 | テーブル名はinventories_rules | E-03 | ○ |
| C-17 | SoftDeletesを使用 | E-03 (use SoftDeletes) | ○ |
| C-18 | ナビゲーションアイコンはclipboard-document-check | E-02 (navigationIcon) | ○ |
| C-19 | navigationSortは4 | E-02 | ○ |
| C-20 | クラスタはConfigurations | E-02 (cluster) | ○ |
| C-21 | 完全削除時に外部キー制約エラーをハンドリング | E-02 (QueryException catch) | ○ |
| C-22 | 削除済みレコードで表示・編集アクションが非表示 | E-02 (hidden fn) | ○ |
| C-23 | マルチステップルート設定が有効な場合のみ表示 | E-02 (isDiscovered) | ○ |
| C-24 | 削除済みソースロケーションもwithTrashedで読み込み | E-02 (getEloquentQuery) | ○ |
| C-25 | 削除済み宛先ロケーションもwithTrashedで読み込み | E-02 (getEloquentQuery) | ○ |
| C-26 | 削除済みルートもwithTrashedで読み込み | E-02 (getEloquentQuery) | ○ |
| C-27 | URL/ルーティングは/inventories/configurations/rules | E-02 (getPages) | ○ |
| C-28 | 編集成功時に成功通知を表示 | E-02 (EditAction successNotification) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] マルチステップルート設定が無効の場合にメニューが非表示になるか確認
- [ ] タブの切り替えが正しく動作するか確認
- [ ] 新規作成時にcreator_id、company_idが正しく設定されるか確認
- [ ] ソフトデリートと復元が正しく動作するか確認
- [ ] 完全削除時の外部キー制約エラーが適切にハンドリングされるか確認
- [ ] フィルタ・グループ化機能が正しく動作するか確認
