---
generated_at: 2025-12-26 18:33:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：129-ロケーション一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/LocationResource/Pages/ListLocations.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/LocationResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Location.php`
- E-04: `plugins/webkul/inventories/src/Enums/LocationType.php`（参照）
- E-05: `plugins/webkul/inventories/src/Settings/WarehouseSettings.php`（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ロケーション一覧画面である | E-01, E-02 | ○ |
| C-02 | Filament ListRecordsを継承 | E-01 | ○ |
| C-03 | 6つのタブがある（すべて/内部/顧客/製造/仕入先/アーカイブ済み） | E-01 (getTabs()) | ○ |
| C-04 | デフォルトタブは「内部」 | E-01 (getDefaultActiveTab) | ○ |
| C-05 | タブにバッジでレコード件数を表示 | E-01 (Tab::make()->badge()) | ○ |
| C-06 | ヘッダーに新規作成ボタンがある | E-01 (getHeaderActions()) | ○ |
| C-07 | 作成時にcreator_idを自動設定 | E-01 (mutateDataUsing) | ○ |
| C-08 | 作成時にcompany_idを自動設定 | E-01 (mutateDataUsing) | ○ |
| C-09 | テーブルにfull_name、type、storageCategory、companyカラムがある | E-02 (table()) | ○ |
| C-10 | 削除日時、作成日時、更新日時はトグル可能 | E-02 (toggleable) | ○ |
| C-11 | タイプ、ストレージカテゴリ、会社でフィルタ可能 | E-02 (filters) | ○ |
| C-12 | 倉庫別、タイプ別でグループ化可能 | E-02 (groups) | ○ |
| C-13 | 表示、編集、復元、削除、完全削除アクションがある | E-02 (recordActions) | ○ |
| C-14 | 表示・編集がモーダル6xlで表示 | E-02 (modalWidth('6xl')) | ○ |
| C-15 | 一括アクション（印刷、復元、削除、完全削除）がある | E-02 (toolbarActions) | ○ |
| C-16 | 空状態時に新規作成アクションを表示 | E-02 (emptyStateActions) | ○ |
| C-17 | モデルはLocation | E-02, E-03 | ○ |
| C-18 | テーブル名はinventories_locations | E-03 | ○ |
| C-19 | SoftDeletesを使用 | E-03 (use SoftDeletes) | ○ |
| C-20 | ナビゲーションアイコンはmap-pin | E-02 (navigationIcon) | ○ |
| C-21 | navigationSortは2 | E-02 | ○ |
| C-22 | クラスタはConfigurations | E-02 (cluster) | ○ |
| C-23 | 完全削除時に外部キー制約エラーをハンドリング | E-02 (QueryException catch) | ○ |
| C-24 | 削除済みレコードで表示・編集アクションが非表示 | E-02 (hidden fn) | ○ |
| C-25 | ロケーション設定が有効な場合のみ表示 | E-02 (isDiscovered) | ○ |
| C-26 | URL/ルーティングは/inventories/configurations/locations | E-02 (getPages) | ○ |
| C-27 | 編集成功時に成功通知を表示 | E-02 (EditAction successNotification) | ○ |
| C-28 | ロケーションは階層構造を持つ | E-03 (parent, children) | ○ |
| C-29 | full_nameが自動計算される | E-03 (updateFullName) | ○ |
| C-30 | parent_pathが自動計算される | E-03 (updateParentPath) | ○ |
| C-31 | 印刷機能でPDFを生成 | E-02 (BulkAction print, PDF::loadView) | ○ |
| C-32 | ManageLocationsからも使用される | E-02 (hiddenOn ManageLocations) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ロケーション設定が無効の場合にメニューが非表示になるか確認
- [ ] タブの切り替えが正しく動作するか確認
- [ ] デフォルトで「内部」タブがアクティブになるか確認
- [ ] 新規作成時にcreator_id、company_idが正しく設定されるか確認
- [ ] モーダル表示（6xl）が正しく動作するか確認
- [ ] ソフトデリートと復元が正しく動作するか確認
- [ ] 完全削除時の外部キー制約エラーが適切にハンドリングされるか確認
- [ ] バーコード印刷機能が正しく動作するか確認
