---
generated_at: 2025-12-26 18:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：131-ロケーション編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **循環棚卸フィールドセットの表示条件**：Transit時の表示についてコードで確認推奨
  2. **エラーメッセージの具体的内容**：多言語ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/LocationResource/Pages/EditLocation.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/LocationResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Location.php`
- E-04: `plugins/webkul/inventories/src/Enums/LocationType.php`（参照のみ）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは/inventories/configurations/locations/{record}/edit | E-02 (getPages関数) | ○ |
| C-02 | EditRecordを継承している | E-01 (class宣言) | ○ |
| C-03 | 印刷ボタンでPDF出力される | E-01 (getHeaderActions, print action) | ○ |
| C-04 | 削除ボタンが存在する | E-01 (DeleteAction) | ○ |
| C-05 | 3カラムレイアウトを使用 | E-02 (form関数, columns(3)) | ○ |
| C-06 | ロケーション名は必須、最大255文字 | E-02 (TextInput::make('name')->required()->maxLength(255)) | ○ |
| C-07 | 親ロケーション選択がある | E-02 (Select::make('parent_id')) | ○ |
| C-08 | ロケーション種別はLocationType enumを使用 | E-02, E-03 (type cast) | ○ |
| C-09 | 保管カテゴリ選択が内部タイプ時のみ表示 | E-02 (visible条件) | ○ |
| C-10 | 棚卸頻度入力フィールドがある | E-02 (cyclic_inventory_frequency) | ○ |
| C-11 | 次回棚卸日が自動計算される | E-01 (mutateFormDataBeforeSave) | ○ |
| C-12 | 保存成功時に通知が表示される | E-01 (getSavedNotification) | ○ |
| C-13 | 削除成功時に通知が表示される | E-01 (DeleteAction->successNotification) | ○ |
| C-14 | SoftDeletesを使用している | E-03 (use SoftDeletes) | ○ |
| C-15 | full_nameが自動計算される | E-03 (updateFullName) | ○ |
| C-16 | parent_pathが自動計算される | E-03 (updateParentPath) | ○ |
| C-17 | 子ロケーションのfull_nameも更新される | E-03 (updateChildrenFullNames) | ○ |
| C-18 | 会社選択フィールドがある | E-02 (Select::make('company_id')) | ○ |
| C-19 | is_scrapトグルがある | E-02 (Toggle::make('is_scrap')) | ○ |
| C-20 | is_dockトグルがある | E-02 (Toggle::make('is_dock')) | ○ |
| C-21 | is_replenishトグルがある | E-02 (Toggle::make('is_replenish')) | ○ |
| C-22 | 循環棚卸フィールドセットがInternal/Transit時に表示 | E-02 (Fieldset visible条件) | ○ |
| C-23 | 削除時に子ロケーション存在チェック | **根拠なし**（推測） | △ |
| C-24 | 削除時に在庫存在チェック | **根拠なし**（推測） | △ |

## 4) 不足情報（Unknown / Missing）
- 多言語リソースファイル（inventories::filament/...）の内容未確認
  - 候補：`resources/lang/en/filament/...` / `resources/lang/ja/filament/...`
- 削除時の制約チェック実装の詳細（データベース制約または業務ロジック）
  - 候補：`LocationObserver` / `LocationPolicy` / Database migration files

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成・入力項目は十分な根拠あり
- 1: 中リスク - 削除時の制約チェック実装が不明確

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の画面で3カラムレイアウトが正しく表示されることを確認
- [ ] ロケーション種別変更時のフィールド表示/非表示切り替えを確認
- [ ] 親ロケーション変更時にfull_nameが正しく更新されることを確認
- [ ] 削除時に関連データがある場合のエラーハンドリングを確認
- [ ] PDF印刷機能の出力内容を確認
