---
generated_at: 2025-12-26 18:14:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：133-パッケージング管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **中間テーブル名**：inventories_route_packagingsの確認推奨
  2. **削除時のルート紐付け削除動作**：カスケード動作の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/PackagingResource/Pages/ManagePackagings.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/PackagingResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Packaging.php`
- E-04: `plugins/webkul/products/src/Filament/Resources/PackagingResource.php`
- E-05: `plugins/webkul/products/src/Filament/Resources/PackagingResource/Pages/ManagePackagings.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは/inventories/configurations/packagings | E-02 (getPages関数) | ○ |
| C-02 | ManageRecordsを継承している | E-01, E-05 (class宣言) | ○ |
| C-03 | パッケージング名は必須、最大255文字 | E-04 (TextInput::make('name')->required()->maxLength(255)) | ○ |
| C-04 | バーコードフィールドがある | E-04 (TextInput::make('barcode')) | ○ |
| C-05 | 商品選択はGOODS・非バリアントのみ | E-02 (ProductType::GOODS, whereNull('is_configurable')) | ○ |
| C-06 | 数量は必須で数値型 | E-04 (TextInput::make('qty')->required()->numeric()) | ○ |
| C-07 | パッケージタイプ選択がある | E-02 (Select::make('package_type_id')) | ○ |
| C-08 | ルート複数選択がある | E-02 (Select::make('routes')->multiple()) | ○ |
| C-09 | パッケージ機能設定に依存してパッケージタイプ表示 | E-02 (visible(static::getOperationSettings()->enable_packages)) | ○ |
| C-10 | マルチステップルート設定に依存してルート表示 | E-02 (visible(static::getWarehouseSettings()->enable_multi_steps_routes)) | ○ |
| C-11 | 作成時にcreator_idが設定される | E-05 (mutateDataUsing, Auth::id()) | ○ |
| C-12 | 印刷一括アクションがある | E-04 (BulkAction::make('print')) | ○ |
| C-13 | 削除一括アクションがある | E-04 (DeleteBulkAction) | ○ |
| C-14 | PDF出力にdompdfを使用 | E-04 (PDF::loadView) | ○ |
| C-15 | 商品でフィルタリング可能 | E-04 (SelectFilter::make('product')) | ○ |
| C-16 | パッケージタイプでフィルタリング可能 | E-02 (SelectFilter::make('packageType')) | ○ |
| C-17 | 商品名でグループ化可能 | E-04 (Group::make('product.name')) | ○ |
| C-18 | 削除済み商品は(Deleted)表示で選択不可 | E-04 (getOptionLabelFromRecordUsing, disableOptionWhen) | ○ |
| C-19 | パッケージタイプ列がある | E-02 (TextColumn::make('packageType.name')) | ○ |
| C-20 | ルートはBelongsToMany関係 | E-03 (routes() function) | ○ |
| C-21 | 中間テーブルはinventories_route_packagings | E-03 (belongsToMany定義) | ○ |
| C-22 | 表示・編集・削除の行アクションがある | E-04 (ViewAction, EditAction, DeleteAction) | ○ |
| C-23 | 詳細表示でinfoolistが使用される | E-02, E-04 (infolist関数) | ○ |
| C-24 | 作成成功通知が表示される | E-05 (successNotification) | ○ |
| C-25 | 削除時にルート紐付けも削除される | **根拠なし**（推測、要マイグレーション確認） | △ |
| C-26 | 作成後に編集画面へリダイレクト | **根拠なし**（推測、ManageRecords標準動作） | △ |

## 4) 不足情報（Unknown / Missing）
- データベースマイグレーションファイル未確認
  - 候補：`database/migrations/...packagings...` / `database/migrations/...route_packagings...`
- 多言語リソースファイル（products::filament/...、inventories::filament/...）の内容未確認
  - 候補：`resources/lang/en/filament/...` / `resources/lang/ja/filament/...`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成・入力項目は十分な根拠あり
- 1: 中リスク - 削除時のカスケード動作を確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] パッケージタイプ選択がパッケージ機能設定に応じて表示/非表示になることを確認
- [ ] ルート選択がマルチステップルート設定に応じて表示/非表示になることを確認
- [ ] 削除済み商品が(Deleted)付きで表示され選択不可になることを確認
- [ ] PDF印刷機能の出力内容を確認
- [ ] ルート紐付けを持つパッケージング削除時の動作を確認
