---
generated_at: 2025-12-26 18:24:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：138-保管カテゴリ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ドラッグ&ドロップ並び替え機能**：実際の動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/StorageCategoryResource/Pages/ListStorageCategories.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/StorageCategoryResource.php`
- E-03: `plugins/webkul/inventories/src/Models/StorageCategory.php`
- E-04: `plugins/webkul/inventories/src/Enums/AllowNewProduct.php`（参照のみ）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは/inventories/configurations/storage-categories | E-02 (getPages関数) | ○ |
| C-02 | ListRecordsを継承している | E-01 (class宣言) | ○ |
| C-03 | ロケーション機能設定に依存して表示 | E-02 (isDiscovered, enable_locations) | ○ |
| C-04 | カテゴリ名カラムがある | E-02 (TextColumn::make('name')) | ○ |
| C-05 | 新商品受け入れカラムがある | E-02 (TextColumn::make('allow_new_products')) | ○ |
| C-06 | 最大重量カラムがある | E-02 (TextColumn::make('max_weight')) | ○ |
| C-07 | 会社名カラムがある | E-02 (TextColumn::make('company.name')) | ○ |
| C-08 | 作成日時カラムがある（デフォルト非表示） | E-02 (TextColumn, toggleable) | ○ |
| C-09 | 更新日時カラムがある（デフォルト非表示） | E-02 (TextColumn, toggleable) | ○ |
| C-10 | 新商品受け入れでグループ化可能 | E-02 (Group::make('allow_new_products')) | ○ |
| C-11 | 作成日でグループ化可能 | E-02 (Group::make('created_at')) | ○ |
| C-12 | 更新日でグループ化可能 | E-02 (Group::make('updated_at')) | ○ |
| C-13 | ViewActionがある | E-02 (recordActions, ViewAction) | ○ |
| C-14 | EditActionがある | E-02 (recordActions, EditAction) | ○ |
| C-15 | DeleteActionがある | E-02 (DeleteAction) | ○ |
| C-16 | 削除一括アクションがある | E-02 (DeleteBulkAction) | ○ |
| C-17 | SortableTrait使用 | E-03 (use SortableTrait) | ○ |
| C-18 | ドラッグ&ドロップで並び替え可能 | **根拠なし**（SortableTraitから推測） | △ |

## 4) 不足情報（Unknown / Missing）
- AllowNewProduct enumの詳細定義
  - 候補：`plugins/webkul/inventories/src/Enums/AllowNewProduct.php`
- Spatie Sortableパッケージの設定詳細
  - 候補：テーブルでのreorderColumn有無
- 多言語リソースファイル（inventories::filament/...）の内容未確認
  - 候補：`resources/lang/en/filament/...` / `resources/lang/ja/filament/...`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 一覧画面の構成・アクションは十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ロケーション機能設定無効時にナビゲーションから非表示になることを確認
- [ ] 新商品受け入れカラムの表示内容（Empty/Same Product/Mixed等）を確認
- [ ] グループ化が正しく動作することを確認
- [ ] 削除時に関連ロケーションがある場合のエラー処理を確認
- [ ] ドラッグ&ドロップ並び替え機能の有無を確認
