---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：141-保管カテゴリ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：正確なパス確認要
  2. **データベーステーブル名**：実テーブル名の確認要
  3. **Enum値**：AllowNewProductの選択肢確認要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/StorageCategoryResource.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/StorageCategoryResource/Pages/ViewStorageCategory.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行141)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行98)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「保管カテゴリ詳細」 | E-03 | ○ |
| C-02 | 在庫管理モジュールのConfigurationsクラスターに属する | E-01 (cluster定義) | ○ |
| C-03 | ViewRecordを継承している | E-02 | ○ |
| C-04 | EditActionがヘッダーアクションに含まれる | E-02 (getHeaderActions) | ○ |
| C-05 | HasRecordNavigationTabsトレイトを使用 | E-02 | ○ |
| C-06 | infolistでname, max_weight, allow_new_products, company.nameを表示 | E-01 (infolist) | ○ |
| C-07 | レコード情報セクションでcreated_at, creator.name, updated_atを表示 | E-01 (infolist) | ○ |
| C-08 | サブナビゲーションにView, Edit, Packages, Products, Locationsがある | E-01 (getRecordSubNavigation) | ○ |
| C-09 | 3カラムレイアウトでinfolistが構成される | E-01 (infolist ->columns(3)) | ○ |
| C-10 | WarehouseSettingsのenable_locationsで表示制御 | E-01 (isDiscovered) | ○ |
| C-11 | RelationGroupでCapacityByPackages, CapacityByProductsがある | E-01 (getRelations) | ○ |
| C-12 | URL形式は /storage-categories/{record} | E-01 (getPages route定義) | ○ |
| C-13 | SubNavigationPositionがTopに設定される | E-01 (getSubNavigationPosition) | ○ |
| C-14 | 画面機能マッピングでFN-INV-028に対応 | E-04 | ○ |
| C-15 | ナビゲーションアイコンはheroicon-o-folder | E-01 ($navigationIcon) | ○ |
| C-16 | navigationSortは4 | E-01 ($navigationSort) | ○ |
| C-17 | recordTitleAttributeはname | E-01 ($recordTitleAttribute) | ○ |
| C-18 | データベーステーブル名はinventories_storage_categories | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- データベーステーブル名の直接的な確認
  - 候補：マイグレーションファイル / Modelクラス / スキーマ定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成・表示項目の大部分はソースコードから確認済み
- 1: 中リスク - データベーステーブル名は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] StorageCategoryモデルのテーブル名を確認
- [ ] 実際の画面でinfolistの表示順序を確認
- [ ] 権限制御の動作確認（enable_locations無効時）
