---
generated_at: 2025-12-26 12:25:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：146-商品一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティングの正確なパス**：Productsクラスターの確認要
  2. **論理削除のモデル設定**：SoftDeletesの適用確認要
  3. **メッセージ内容**：翻訳ファイルの確認要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/ProductResource.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/ProductResource/Pages/ListProducts.php`
- E-03: `plugins/webkul/products/src/Filament/Resources/ProductResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行146)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行90)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「商品一覧」 | E-04 | ○ |
| C-02 | BaseListProductsを継承している | E-02 (extends BaseListProducts) | ○ |
| C-03 | Productsクラスターに属する | E-01 ($cluster) | ○ |
| C-04 | プリセットビュー storable_products がある | E-02 (getPresetTableViews) | ○ |
| C-05 | is_storable=trueで絞り込む | E-02 (where is_storable, true) | ○ |
| C-06 | テーブルカラムにis_favorite, images, name等がある | E-03 (table columns) | ○ |
| C-07 | imagesは円形・スタック・最大3枚 | E-03 (circular, stacked, limit(3)) | ○ |
| C-08 | お気に入りアイコンクリックでis_favorite反転 | E-03 (IconColumn action) | ○ |
| C-09 | reorderableColumns有効 | E-03 (reorderableColumns) | ○ |
| C-10 | columnManagerColumnsが2 | E-03 (columnManagerColumns(2)) | ○ |
| C-11 | sort列でreorderable | E-03 (reorderable sort) | ○ |
| C-12 | defaultSortはsort desc | E-03 (defaultSort sort, desc) | ○ |
| C-13 | QueryBuilderフィルターが設定されている | E-03 (QueryBuilder::make) | ○ |
| C-14 | フィルターレイアウトはModal | E-03 (FiltersLayout::Modal) | ○ |
| C-15 | filtersTriggerActionはslideOver | E-03 (slideOver) | ○ |
| C-16 | グルーピングにtype, category, created_atがある | E-03 (groups) | ○ |
| C-17 | 行アクションにView, Edit, Delete, Restore, ForceDeleteがある | E-03 (recordActions) | ○ |
| C-18 | 削除済み商品ではViewとEditが非表示 | E-03 (hidden trashed) | ○ |
| C-19 | 一括印刷アクションがある | E-03 (BulkAction print) | ○ |
| C-20 | 印刷フォーマットにdymo, 2x7_price等がある | E-03 (format options) | ○ |
| C-21 | PDFをstreamDownloadで出力 | E-03 (streamDownload) | ○ |
| C-22 | 一括削除・復元・完全削除アクションがある | E-03 (toolbarActions) | ○ |
| C-23 | 完全削除時にQueryExceptionを捕捉 | E-03 (ForceDeleteAction catch) | ○ |
| C-24 | navigationSortは1 | E-01 ($navigationSort) | ○ |
| C-25 | 正確なルーティングパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 正確なURL/ルーティングパスの確認
  - 候補：ルート定義ファイル / Productsクラスターのパス設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構成・アクションの大部分はソースコードから確認済み
- 0: 低リスク - プリセットビューの設定はソースコードから正確に特定

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のアプリケーションでURL/ルーティングを確認
- [ ] 在庫管理プリセットビューの動作を確認
- [ ] 印刷機能のPDF出力を確認
- [ ] 論理削除・復元・完全削除の動作を確認
