---
generated_at: 2025-12-26 12:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：147-商品作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **データベーステーブル名**：実テーブル名の確認要
  2. **中間テーブル名**：product_route, products_tagsの確認要
  3. **カスタムフィールドの動作**：HasCustomFieldsトレイトの確認要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/ProductResource.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/ProductResource/Pages/CreateProduct.php`
- E-03: `plugins/webkul/products/src/Filament/Resources/ProductResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行147)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「商品作成」 | E-04 | ○ |
| C-02 | BaseCreateProductを継承している | E-02 (extends BaseCreateProduct) | ○ |
| C-03 | フォームにname, description, tagsがある | E-03 (form Section) | ○ |
| C-04 | nameは大きめスタイル | E-03 (extraInputAttributes style) | ○ |
| C-05 | descriptionはRichEditor | E-03 (RichEditor) | ○ |
| C-06 | tagsは複数選択・作成可能 | E-03 (Select multiple, createOptionForm) | ○ |
| C-07 | imagesセクションがある | E-03 (Section images) | ○ |
| C-08 | imagesはFileUpload複数可 | E-03 (FileUpload multiple) | ○ |
| C-09 | typeはRadioで選択 | E-03 (Radio type) | ○ |
| C-10 | typeデフォルトはGOODS | E-03 (default ProductType::GOODS) | ○ |
| C-11 | category_idはSelect（作成可能） | E-03 (Select createOptionForm) | ○ |
| C-12 | company_idはデフォルトでログインユーザーの会社 | E-03 (default Auth::user()->default_company_id) | ○ |
| C-13 | priceは必須・デフォルト0 | E-03 (required, default 0.00) | ○ |
| C-14 | uom_id, uom_po_idはHiddenフィールド | E-03 (Hidden) | ○ |
| C-15 | インベントリセクションはGOODS時のみ表示 | E-01 (visible type==GOODS) | ○ |
| C-16 | is_storableはToggle | E-01 (Toggle is_storable) | ○ |
| C-17 | is_storableデフォルトはtrue | E-01 (default true) | ○ |
| C-18 | trackingはSelect | E-01 (Select tracking) | ○ |
| C-19 | trackingはTraceabilitySettings有効時のみ表示 | E-01 (visible settings) | ○ |
| C-20 | routesはCheckboxList | E-01 (CheckboxList routes) | ○ |
| C-21 | routesはproduct_selectable=trueのみ | E-01 (where product_selectable, true) | ○ |
| C-22 | responsible_idはSelect | E-01 (Select responsible_id) | ○ |
| C-23 | weight, volume, sale_delayはTextInput | E-01 (TextInput) | ○ |
| C-24 | トレーサビリティフィールドセットはuse_expiration_date時のみ | E-01 (visible use_expiration_date) | ○ |
| C-25 | expiration_time等がある | E-01 (TextInput expiration_time) | ○ |
| C-26 | HasCustomFieldsトレイトを使用 | E-01 (use HasCustomFields) | ○ |
| C-27 | 追加セクションはカスタムフィールド設定時のみ | E-01 (visible customFormFields) | ○ |
| C-28 | テーブル名はproducts | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- データベーステーブル名の直接的な確認
  - 候補：Productモデル / マイグレーションファイル
- 中間テーブル名の確認
  - 候補：リレーション定義 / マイグレーションファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構成・入力項目の大部分はソースコードから確認済み
- 0: 低リスク - 表示条件の制御ロジックはソースコードから正確に特定

## 6) レビュアーチェックリスト（最小）
- [ ] Productモデルのテーブル名を確認
- [ ] tags, routesリレーションの中間テーブル名を確認
- [ ] 実際の画面でフォームの表示制御を確認
- [ ] カスタムフィールド設定時の追加セクション表示を確認
