---
generated_at: 2025-12-26 12:35:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：148-商品編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **移動レコード作成ロジック**：createMoveメソッドの詳細確認要
  2. **調整ロケーションの特定ロジック**：LocationType列挙型の確認要
  3. **サブナビゲーションの順序**：実際の表示順序確認要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/ProductResource.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/ProductResource/Pages/EditProduct.php`
- E-03: `plugins/webkul/products/src/Filament/Resources/ProductResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行148)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「商品編集」 | E-04 | ○ |
| C-02 | BaseEditProductを継承している | E-02 (extends BaseEditProduct) | ○ |
| C-03 | 数量更新アクションがヘッダーにある | E-02 (getHeaderActions updateQuantity) | ○ |
| C-04 | 数量更新はis_storable時のみ表示 | E-02 (visible is_storable) | ○ |
| C-05 | ダイアログにproduct_id Selectがある | E-02 (Select product_id) | ○ |
| C-06 | product_idはコンフィギュラブル時のみ表示 | E-02 (visible is_configurable) | ○ |
| C-07 | バリエーションを選択するとquantityが更新される | E-02 (afterStateUpdated) | ○ |
| C-08 | quantityはTextInput数値 | E-02 (TextInput numeric) | ○ |
| C-09 | パッケージ/ロケーション/ロット管理有効時はリダイレクト | E-02 (beforeFormFilled redirect) | ○ |
| C-10 | 数量管理画面へリダイレクト | E-02 (getUrl quantities) | ○ |
| C-11 | 数量更新時にProductQuantityを更新/作成 | E-02 (action ProductQuantity) | ○ |
| C-12 | ProductQuantityはproduct_id, location_idで検索 | E-02 (where product_id, location_id) | ○ |
| C-13 | 既存レコードはupdateで更新 | E-02 (update quantity) | ○ |
| C-14 | 新規レコードはcreateで作成 | E-02 (ProductQuantity::create) | ○ |
| C-15 | createMoveメソッドで移動レコードを作成 | E-02 (createMove) | ○ |
| C-16 | createMoveはProductResource静的メソッド | E-01 (static createMove) | ○ |
| C-17 | Moveを作成しstateはDONE | E-01 (MoveState::DONE) | ○ |
| C-18 | Moveの参照は'Product Quantity Updated' | E-01 (reference) | ○ |
| C-19 | MoveLinesも作成される | E-01 (move->lines()->create) | ○ |
| C-20 | 調整ロケーションはtype=INVENTORY, is_scrap=false | E-02 (LocationType::INVENTORY, is_scrap false) | ○ |
| C-21 | 倉庫はWarehouse::first()で取得 | E-02 (Warehouse::first) | ○ |
| C-22 | 増加時はadjustment→lot_stock、減少時は逆 | E-02 (if currentQuantity < 0) | ○ |
| C-23 | サブナビゲーションにView, Edit, Attributes, Variants, Quantities, Movesがある | E-01 (getRecordSubNavigation) | ○ |
| C-24 | 数量が変化しない場合は処理をスキップ | E-02 (if previousQuantity == quantity return) | ○ |
| C-25 | バリエーション選択時はproduct_idでProductを再取得 | E-02 (Product::find product_id) | ○ |
| C-26 | テーブル名inventories_product_quantities | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- データベーステーブル名の直接的な確認
  - 候補：ProductQuantityモデル / マイグレーションファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 数量更新ロジックはソースコードから詳細に確認済み
- 0: 低リスク - リダイレクト条件はソースコードから正確に特定
- 1: 中リスク - テーブル名は推測

## 6) レビュアーチェックリスト（最小）
- [ ] ProductQuantityモデルのテーブル名を確認
- [ ] Move, MoveLineモデルのテーブル名を確認
- [ ] 実際の画面で数量更新機能の動作を確認
- [ ] パッケージ/ロケーション/ロット管理有効時のリダイレクトを確認
