---
generated_at: 2025-12-26 12:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：149-商品詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：正確なパス確認要
  2. **表示項目の順序**：実際の表示順序確認要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/ProductResource.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/ProductResource/Pages/ViewProduct.php`
- E-03: `plugins/webkul/products/src/Filament/Resources/ProductResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行149)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「商品詳細」 | E-04 | ○ |
| C-02 | BaseViewProductを継承している | E-02 (extends BaseViewProduct) | ○ |
| C-03 | infolistにname, description, tags.nameがある | E-03 (infolist) | ○ |
| C-04 | tagsはバッジ表示・太字 | E-03 (badge, FontWeight::Bold) | ○ |
| C-05 | 画像セクションはimagesがある場合のみ表示 | E-03 (visible images) | ○ |
| C-06 | インベントリセクションはGOODS時のみ表示 | E-01 (visible type==GOODS) | ○ |
| C-07 | is_storable, tracking, use_expiration_dateを表示 | E-01 (infolist IconEntry, TextEntry) | ○ |
| C-08 | is_storableはIconEntry boolean | E-01 (IconEntry boolean) | ○ |
| C-09 | routesは改行区切りリスト表示 | E-01 (listWithLineBreaks) | ○ |
| C-10 | responsible, weight, volume, sale_delayを表示 | E-01 (TextEntry) | ○ |
| C-11 | トレーサビリティはuse_expiration_date時のみ | E-01 (visible use_expiration_date) | ○ |
| C-12 | expiration_time等を表示 | E-01 (TextEntry) | ○ |
| C-13 | レコード情報にcreated_at, creator.name, updated_atがある | E-03 (infolist record-information) | ○ |
| C-14 | 設定セクションにtype, reference, barcode, category, companyがある | E-03 (infolist settings) | ○ |
| C-15 | 価格セクションにprice, costがある | E-03 (infolist pricing) | ○ |
| C-16 | 3カラムレイアウト | E-03 (columns(3)) | ○ |
| C-17 | 左グループは2カラム幅 | E-03 (columnSpan lg:2) | ○ |
| C-18 | 右グループは1カラム幅 | E-03 (columnSpan lg:1) | ○ |
| C-19 | サブナビゲーションにView, Edit, Attributes, Variants, Quantities, Movesがある | E-01 (getRecordSubNavigation) | ○ |
| C-20 | 未設定値はプレースホルダー「—」 | E-01, E-03 (placeholder) | ○ |
| C-21 | 各アイコンが正しく設定されている | E-01, E-03 (icon) | ○ |
| C-22 | 正確なルーティングパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 正確なURL/ルーティングパスの確認
  - 候補：ルート定義ファイル / Productsクラスターのパス設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成・表示項目の大部分はソースコードから確認済み
- 0: 低リスク - infolistの構造はソースコードから正確に特定

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のアプリケーションでURL/ルーティングを確認
- [ ] 実際の画面でinfolistの表示を確認
- [ ] インベントリセクションの表示制御を確認
- [ ] トレーサビリティセクションの表示制御を確認
