---
generated_at: 2025-12-26 18:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-クレジットノート一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/CreditNoteResource/Pages/ListCreditNotes.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/CreditNoteResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php`
- E-04: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Pages/ListInvoices.php`
- E-05: `plugins/webkul/accounts/src/Models/Move.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「クレジットノート一覧」である | E-06 | ○ |
| C-02 | ListInvoices（ListRecords）を継承している | E-01 | ○ |
| C-03 | CreditNoteResourceはInvoiceResourceを継承 | E-02 | ○ |
| C-04 | HasTableViewsトレイトを使用 | E-01 | ○ |
| C-05 | デフォルトビューはout_refundでフィルタリング | E-01 (getPresetTableViews) | ○ |
| C-06 | invoiceビューは除外される | E-01 (Arr::except 'invoice') | ○ |
| C-07 | モデルはAccountMove | E-02 ($model) | ○ |
| C-08 | テーブル名はaccounts_account_moves | E-05 ($table) | ○ |
| C-09 | ヘッダーに作成ボタンがある | E-04 (getHeaderActions) | ○ |
| C-10 | 作成ボタンにheroicon-o-plus-circleアイコン | E-04 | ○ |
| C-11 | テーブルに複数のカラムがある | E-03 (table method) | ○ |
| C-12 | 各行にView/Edit/Deleteアクションがある | E-03 (recordActions) | ○ |
| C-13 | 一括削除機能がある | E-03 (toolbarActions, DeleteBulkAction) | ○ |
| C-14 | グループ化機能がある | E-03 (groups) | ○ |
| C-15 | 合計表示（Sum Summarizer）がある | E-03 (summarize Sum::make) | ○ |
| C-16 | フィルタ機能がある | E-03 (filters QueryBuilder) | ○ |
| C-17 | プリセットビューが複数存在 | E-04, E-01 (getPresetTableViews) | ○ |
| C-18 | move_typeはEnumで管理 | E-05 ($casts MoveType) | ○ |
| C-19 | payment_stateはEnumで管理 | E-05 ($casts PaymentState) | ○ |
| C-20 | ルーティングは'/' | E-02 (getPages) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] プリセットビューのフィルタリングが正しく動作するか確認
- [ ] InvoiceResourceから継承された機能が正しく動作するか確認
- [ ] 合計表示が正しく計算されるか確認
