---
generated_at: 2025-12-26 12:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：150-パッケージ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **データベーステーブル名**：実テーブル名の確認要
  2. **バーコード印刷テンプレート**：Bladeファイルの確認要
  3. **ロケーションタイプ列挙値**：LocationType::INTERNALの確認要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/PackageResource.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/PackageResource/Pages/ListPackages.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行150)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行91)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「パッケージ一覧」 | E-03 | ○ |
| C-02 | ListRecordsを使用している | E-02 (extends ListRecords) | ○ |
| C-03 | HasTableViewsトレイトを使用 | E-02 (use HasTableViews) | ○ |
| C-04 | プリセットビュー internal_locations がある | E-02 (getPresetTableViews) | ○ |
| C-05 | internal_locationsはデフォルト・お気に入り | E-02 (favorite, setAsDefault) | ○ |
| C-06 | LocationType::INTERNALで絞り込む | E-02 (where type INTERNAL) | ○ |
| C-07 | CreateActionがヘッダーにある | E-02 (getHeaderActions) | ○ |
| C-08 | テーブルカラムにname, packageType.name, location.full_name, company.nameがある | E-01 (table columns) | ○ |
| C-09 | nameは検索・ソート可能 | E-01 (searchable, sortable) | ○ |
| C-10 | グルーピングにpackageType, location, created_atがある | E-01 (groups) | ○ |
| C-11 | フィルターにpackage_type_id, location_id, creator_id, company_idがある | E-01 (filters) | ○ |
| C-12 | 行アクションにView, Edit, Deleteがある | E-01 (recordActions) | ○ |
| C-13 | 行アクションはActionGroupでグルーピング | E-01 (ActionGroup) | ○ |
| C-14 | 削除時にQueryException処理がある | E-01 (DeleteAction catch) | ○ |
| C-15 | 一括印刷アクションがある（内容なし/あり） | E-01 (BulkAction print-without-content, print-with-content) | ○ |
| C-16 | PDF出力はA4縦向き | E-01 (setPaper a4, portrait) | ○ |
| C-17 | 一括削除アクションがある | E-01 (DeleteBulkAction) | ○ |
| C-18 | 一括削除でQueryException処理がある | E-01 (DeleteBulkAction catch) | ○ |
| C-19 | OperationSettingsのenable_packagesで表示制御 | E-01 (isDiscovered) | ○ |
| C-20 | recordTitleAttributeはname | E-01 ($recordTitleAttribute) | ○ |
| C-21 | navigationSortは2 | E-01 ($navigationSort) | ○ |
| C-22 | ナビゲーションアイコンはheroicon-o-cube | E-01 ($navigationIcon) | ○ |
| C-23 | Productsクラスターに属する | E-01 ($cluster) | ○ |
| C-24 | テーブル名はinventories_packages | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- データベーステーブル名の直接的な確認
  - 候補：Packageモデル / マイグレーションファイル
- バーコード印刷テンプレートの確認
  - 候補：`resources/views/inventories/filament/clusters/products/packages/actions/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構成・アクションの大部分はソースコードから確認済み
- 0: 低リスク - プリセットビューの設定はソースコードから正確に特定

## 6) レビュアーチェックリスト（最小）
- [ ] Packageモデルのテーブル名を確認
- [ ] バーコード印刷テンプレートの存在と内容を確認
- [ ] プリセットビューの動作を確認
- [ ] パッケージ機能無効時のアクセス制御を確認
