---
generated_at: 2025-12-26 12:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：153-パッケージ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。レビュー優先度は低い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/PackageResource/Pages/ViewPackage.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/PackageResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Package.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は「詳細」 | E-01 (ViewRecord継承) | ○ |
| C-02 | URLは/{record} | E-02 (ViewPackage::route('/{record}')) | ○ |
| C-03 | 印刷アクションが2種類存在 | E-01 (print-without-content, print-with-content) | ○ |
| C-04 | 印刷はPDFでダウンロード | E-01 (PDF::loadView, streamDownload) | ○ |
| C-05 | 削除アクションが存在 | E-01 (DeleteAction::make()) | ○ |
| C-06 | 削除失敗時はエラー通知 | E-01 (QueryException catch) | ○ |
| C-07 | HasRecordNavigationTabsを使用 | E-01 (use HasRecordNavigationTabs) | ○ |
| C-08 | パッケージ名は大サイズ、太字 | E-02 (TextSize::Large, FontWeight::Bold) | ○ |
| C-09 | 商品数量はバッジ表示 | E-02 (quantities_count->badge()) | ○ |
| C-10 | ロケーションはfull_nameで表示 | E-02 (location.full_name) | ○ |
| C-11 | パック日は日付形式で表示 | E-02 (pack_date->date()) | ○ |
| C-12 | 作成日時は日時形式で表示 | E-02 (created_at->dateTime()) | ○ |
| C-13 | 各項目にアイコンが付与 | E-02 (TextEntry->icon()) | ○ |
| C-14 | サブナビゲーションに4つの画面 | E-02 (getRecordSubNavigation) | ○ |
| C-15 | ActionGroupで印刷アクションをまとめる | E-01 (ActionGroup::make) | ○ |
| C-16 | レイアウトは3カラム | E-02 (columns(3)) | ○ |
| C-17 | レコード情報セクションが存在 | E-02 (Section 'Record Information') | ○ |
| C-18 | 一般情報セクションが存在 | E-02 (Section 'General') | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Infolist表示が正常にレンダリングされるか確認
- [ ] PDF印刷機能が正常に動作するか確認
- [ ] サブナビゲーションが正しく表示されるか確認
