---
generated_at: 2025-12-26 12:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：154-ロット一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。レビュー優先度は低い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/LotResource/Pages/ListLots.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/LotResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Lot.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は「一覧」 | E-01 (ListRecords継承) | ○ |
| C-02 | URLは/inventories/products/lots | E-02 (ListLots::route('/')) | ○ |
| C-03 | 作成ボタンが存在 | E-01 (CreateAction::make()) | ○ |
| C-04 | 作成ボタンにplus-circleアイコン | E-01 (icon('heroicon-o-plus-circle')) | ○ |
| C-05 | テーブルカラムにname, product, reference, total_quantity等 | E-02 (TextColumn定義) | ○ |
| C-06 | referenceはプレースホルダー「—」 | E-02 (placeholder('—')) | ○ |
| C-07 | created_at, updated_atはデフォルト非表示 | E-02 (toggleable(isToggledHiddenByDefault: true)) | ○ |
| C-08 | グループ化オプションが3種類 | E-02 (Groups: product.name, location.full_name, created_at) | ○ |
| C-09 | フィルターオプションが4種類 | E-02 (SelectFilter: product_id, location_id, creator_id, company_id) | ○ |
| C-10 | location_idフィルターは複数選択可 | E-02 (multiple()) | ○ |
| C-11 | 行アクションにView, Edit, Delete | E-02 (ActionGroup: ViewAction, EditAction, DeleteAction) | ○ |
| C-12 | 削除失敗時はエラー通知 | E-02 (QueryException catch, Notification danger) | ○ |
| C-13 | 一括印刷アクションが存在 | E-02 (BulkAction::make('print')) | ○ |
| C-14 | 一括印刷のPDFファイル名はLot-Barcode.pdf | E-02 ('Lot-Barcode.pdf') | ○ |
| C-15 | 一括削除アクションが存在 | E-02 (DeleteBulkAction::make()) | ○ |
| C-16 | 機能はenable_lots_serial_numbersで制御 | E-02 (isDiscovered() checks enable_lots_serial_numbers) | ○ |
| C-17 | HasTableViewsを使用 | E-01 (use HasTableViews) | ○ |
| C-18 | total_quantityは計算値 | E-03 (getTotalQuantityAttribute()) | ○ |
| C-19 | total_quantityは内部ロケーション（スクラップ以外）の合計 | E-03 (whereHas location INTERNAL, is_scrap false) | ○ |
| C-20 | テーブル名はinventories_lots | E-03 ($table = 'inventories_lots') | ○ |
| C-21 | ナビゲーションアイコンはrectangle-stack | E-02 (navigationIcon = 'heroicon-o-rectangle-stack') | ○ |
| C-22 | ナビゲーションソート順は3 | E-02 (navigationSort = 3) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] テーブル表示が正常にレンダリングされるか確認
- [ ] フィルター機能が正常に動作するか確認
- [ ] 一括印刷でPDFが正常に生成されるか確認
- [ ] 削除時の参照整合性エラーが適切にハンドリングされるか確認
