---
generated_at: 2025-12-26 12:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：155-ロット作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。レビュー優先度は低い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/LotResource/Pages/CreateLot.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/LotResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Lot.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は「登録」 | E-01 (CreateRecord継承) | ○ |
| C-02 | URLは/inventories/products/lots/create | E-02 (CreateLot::route('/create')) | ○ |
| C-03 | ロット名は必須、最大255文字 | E-02 (TextInput->required()->maxLength(255)) | ○ |
| C-04 | ロット名は自動フォーカス | E-02 (autofocus()) | ○ |
| C-05 | ロット名に大サイズのカスタムスタイル | E-02 (extraInputAttributes font-size: 1.5rem, height: 3rem) | ○ |
| C-06 | 商品は必須、検索可能 | E-02 (Select->required()->searchable()->preload()) | ○ |
| C-07 | 商品はLOTトラッキング商品のみ | E-02 (where('tracking', ProductTracking::LOT)) | ○ |
| C-08 | 商品はis_configurable=nullの商品のみ | E-02 (whereNull('is_configurable')) | ○ |
| C-09 | 参照は最大255文字 | E-02 (TextInput->maxLength(255)) | ○ |
| C-10 | 説明はリッチエディター | E-02 (RichEditor::make('description')) | ○ |
| C-11 | 説明は2カラム幅 | E-02 (columnSpan(2)) | ○ |
| C-12 | 商品と参照にヒントアイコン | E-02 (hintIcon('heroicon-m-question-mark-circle')) | ○ |
| C-13 | 商品選択は特定画面で非表示 | E-02 (hiddenOn([EditReceipt, EditDelivery, ...])) | ○ |
| C-14 | セクションは一般情報 | E-02 (Section::make 'General') | ○ |
| C-15 | グループレイアウトは2カラム | E-02 (Group->columns(2)) | ○ |
| C-16 | テーブル名はinventories_lots | E-03 ($table = 'inventories_lots') | ○ |
| C-17 | descriptionはfillable | E-03 (fillable includes 'description') | ○ |
| C-18 | サブナビゲーションはクラスター生成 | E-01 (getSubNavigation, getClusteredComponents) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 商品選択でLOTトラッキング商品のみが表示されるか確認
- [ ] ロット名の大サイズスタイルが正しく適用されるか確認
- [ ] リッチエディターが正常に動作するか確認
