---
generated_at: 2025-12-26 12:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：156-ロット編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。レビュー優先度は低い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/LotResource/Pages/EditLot.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/LotResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Lot.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は「編集」 | E-01 (EditRecord継承) | ○ |
| C-02 | URLは/{record}/edit | E-02 (EditLot::route('/{record}/edit')) | ○ |
| C-03 | 印刷アクションが存在 | E-01 (Action::make('print')) | ○ |
| C-04 | 印刷はPDFでダウンロード | E-01 (PDF::loadView, streamDownload) | ○ |
| C-05 | PDFファイル名はLot-{name}.pdf | E-01 ('Lot-'.str_replace('/', '_', $record->name).'.pdf') | ○ |
| C-06 | スラッシュはアンダースコアに置換 | E-01 (str_replace('/', '_', $record->name)) | ○ |
| C-07 | 削除アクションが存在 | E-01 (DeleteAction::make()) | ○ |
| C-08 | 削除失敗時はエラー通知 | E-01 (QueryException catch, Notification danger) | ○ |
| C-09 | 削除成功時は成功通知 | E-01 (successNotification) | ○ |
| C-10 | HasRecordNavigationTabsを使用 | E-01 (use HasRecordNavigationTabs) | ○ |
| C-11 | 保存成功時に通知を表示 | E-01 (getSavedNotification) | ○ |
| C-12 | 印刷ボタンのアイコンはprinter | E-01 (icon('heroicon-o-printer')) | ○ |
| C-13 | 印刷ボタンの色はgray | E-01 (color('gray')) | ○ |
| C-14 | サブナビゲーションに3画面 | E-02 (getRecordSubNavigation: ViewLot, EditLot, ManageQuantities) | ○ |
| C-15 | ロット名は必須、最大255文字 | E-02 (TextInput->required()->maxLength(255)) | ○ |
| C-16 | 商品はLOTトラッキング商品のみ | E-02 (where('tracking', ProductTracking::LOT)) | ○ |
| C-17 | 説明はリッチエディター | E-02 (RichEditor::make('description')) | ○ |
| C-18 | PDFはA4縦サイズ | E-01 ($pdf->setPaper('a4', 'portrait')) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PDF印刷機能が正常に動作するか確認
- [ ] スラッシュを含むロット名のPDFファイル名が正しく生成されるか確認
- [ ] 削除時の参照整合性エラーが適切にハンドリングされるか確認
- [ ] サブナビゲーションが正しく表示されるか確認
