---
generated_at: 2025-12-26 12:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：158-入庫一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。レビュー優先度は低い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource/Pages/ListReceipts.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `plugins/webkul/inventories/src/Models/Operation.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は「一覧」 | E-01 (ListRecords継承) | ○ |
| C-02 | URLは/inventories/operations/receipts | E-02 (ListReceipts::route('/')) | ○ |
| C-03 | 作成ボタンが存在 | E-01 (CreateAction::make()) | ○ |
| C-04 | HasTableViewsを使用 | E-01 (use HasTableViews) | ○ |
| C-05 | プリセットビューはOperationResourceから取得 | E-01 (OperationResource::getPresetTableViews()) | ○ |
| C-06 | operationType.type = INCOMINGでフィルタリング | E-02 (modifyQueryUsing where type INCOMING) | ○ |
| C-07 | お気に入りアイコンで星を表示 | E-03 (IconColumn is_favorite heroicon-s-star/heroicon-o-star) | ○ |
| C-08 | お気に入りクリックでトグル | E-03 (is_favorite action update) | ○ |
| C-09 | ステータスはバッジ表示 | E-03 (TextColumn state->badge()) | ○ |
| C-10 | 完了済みは削除不可 | E-02 (hidden state == DONE) | ○ |
| C-11 | 完了済みはチェックボックス無効 | E-03 (checkIfRecordIsSelectableUsing state !== DONE) | ○ |
| C-12 | グループ化オプションが5種類 | E-03 (Groups: state, origin, operationType.name, scheduled_at, created_at) | ○ |
| C-13 | QueryBuilder形式のフィルター | E-03 (QueryBuilder::make()) | ○ |
| C-14 | フィルターはモーダル表示 | E-03 (FiltersLayout::Modal) | ○ |
| C-15 | フィルターはスライドオーバー | E-03 (filtersTriggerAction slideOver) | ○ |
| C-16 | フィルターは2カラム | E-03 (filtersFormColumns(2)) | ○ |
| C-17 | ロケーション表示はenable_locationsで制御 | E-03 (visible getWarehouseSettings()->enable_locations) | ○ |
| C-18 | テーブルカラムは並び替え可能 | E-03 (reorderableColumns()) | ○ |
| C-19 | カラムマネージャー2カラム | E-03 (columnManagerColumns(2)) | ○ |
| C-20 | 削除失敗時はエラー通知 | E-02 (QueryException catch Notification danger) | ○ |
| C-21 | 一括削除アクションが存在 | E-02 (DeleteBulkAction::make()) | ○ |
| C-22 | 行アクションにView, Edit, Delete | E-02 (ActionGroup: ViewAction, EditAction, DeleteAction) | ○ |
| C-23 | テーブル名はinventories_operations | E-04 ($table = 'inventories_operations') | ○ |
| C-24 | stateはOperationStateEnum | E-04 (casts state => OperationState::class) | ○ |
| C-25 | is_favoriteはboolean | E-04 (casts is_favorite => boolean) | ○ |
| C-26 | scheduled_atはdatetime | E-04 (casts scheduled_at => datetime) | ○ |
| C-27 | プリセットビューが8種類 | E-03 (getPresetTableViews: todo, my, favorite, draft, waiting, ready, done, canceled) | ○ |
| C-28 | 一覧はIDの降順でソート | E-02 (getEloquentQuery orderByDesc('id')) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] プリセットビューが正常に切り替わるか確認
- [ ] QueryBuilderフィルターが正常に動作するか確認
- [ ] 完了済みオペレーションの削除が適切にブロックされるか確認
- [ ] お気に入りトグルが正常に動作するか確認
