---
generated_at: 2025-12-26 12:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：159-入庫作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。レビュー優先度は低い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource/Pages/CreateReceipt.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `plugins/webkul/inventories/src/Models/Operation.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は「登録」 | E-01 (CreateRecord継承) | ○ |
| C-02 | URLは/inventories/operations/receipts/create | E-02 (CreateReceipt::route('/create')) | ○ |
| C-03 | mountでオペレーションタイプがデフォルト設定 | E-01 (mount: operation_type_id = OperationType INCOMING) | ○ |
| C-04 | mountで元・先ロケーションがデフォルト設定 | E-01 (mount: source_location_id, destination_location_id) | ○ |
| C-05 | 保存後は編集画面にリダイレクト | E-01 (getRedirectUrl returns 'edit') | ○ |
| C-06 | HasRepeaterColumnManagerを使用 | E-01 (use HasRepeaterColumnManager) | ○ |
| C-07 | 成功通知を表示 | E-01 (getCreatedNotification) | ○ |
| C-08 | stateはDRAFTがデフォルト | E-01 (mutateFormDataBeforeCreate state DRAFT) | ○ |
| C-09 | creator_idは自動設定 | E-01 (mutateFormDataBeforeCreate creator_id Auth::id()) | ○ |
| C-10 | company_idは先ロケーションの会社IDから取得 | E-01 (destinationLocation->company_id) | ○ |
| C-11 | 仕入先は入庫タイプで表示 | E-03 (partner_id visible INCOMING) | ○ |
| C-12 | 仕入先は新規作成可能 | E-03 (createOptionForm PartnerResource::form) | ○ |
| C-13 | オペレーションタイプはライブ更新 | E-03 (operation_type_id->live()) | ○ |
| C-14 | オペレーションタイプ変更でロケーション自動設定 | E-03 (afterStateUpdated set source/destination) | ○ |
| C-15 | 先ロケーションはロケーション有効時のみ表示 | E-03 (visible enable_locations) | ○ |
| C-16 | 商品選択は重複不可 | E-03 (product_id distinct()) | ○ |
| C-17 | 削除済みレコードは選択不可 | E-03 (disableOptionWhen (Deleted)) | ○ |
| C-18 | 商品選択でUOMが自動設定 | E-03 (afterProductUpdated set uom_id) | ○ |
| C-19 | 需要数量変更でパッケージング自動設定 | E-03 (afterProductUOMQtyUpdated getBestPackaging) | ○ |
| C-20 | ステータスステッパーが表示される | E-03 (ProgressStepper::make('state')) | ○ |
| C-21 | ステータスステッパーは無効 | E-03 (ProgressStepper->disabled()) | ○ |
| C-22 | タブ構成: オペレーション/追加情報/メモ | E-03 (Tabs: operations/additional/note) | ○ |
| C-23 | 担当者のデフォルトはログインユーザー | E-03 (user_id default Auth::id()) | ○ |
| C-24 | 配送ポリシーのデフォルトはDIRECT | E-03 (move_type default DIRECT) | ○ |
| C-25 | 予定日のデフォルトは現在日時 | E-03 (scheduled_at default now()) | ○ |
| C-26 | 入庫では元ロケーションは非表示 | E-03 (source_location_id visible != INCOMING) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] オペレーションタイプ変更でロケーションが正しく更新されるか確認
- [ ] Movesリピーターで商品選択が正常に動作するか確認
- [ ] 仕入先の新規作成がフォーム内で正常に動作するか確認
- [ ] 保存後に編集画面にリダイレクトされるか確認
