---
generated_at: 2025-12-26 18:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-クレジットノート作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/CreditNoteResource/Pages/CreateCreditNote.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/CreditNoteResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php`
- E-04: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Pages/CreateInvoice.php`
- E-05: `plugins/webkul/accounts/src/Models/Move.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「クレジットノート作成」である | E-06 | ○ |
| C-02 | CreateInvoice（CreateRecord）を継承している | E-01 | ○ |
| C-03 | リダイレクト先は詳細画面（view） | E-01 (getRedirectUrl) | ○ |
| C-04 | 成功通知が表示される | E-01 (getCreatedNotification) | ○ |
| C-05 | move_typeはOUT_REFUNDがデフォルト | E-01 (mutateFormDataBeforeCreate) | ○ |
| C-06 | dateは現在日時で設定 | E-01 (mutateFormDataBeforeCreate) | ○ |
| C-07 | afterCreateでAccount::computeAccountMoveが実行 | E-01 (afterCreate) | ○ |
| C-08 | フォームはInvoiceResourceのformを使用 | E-03 (form method) | ○ |
| C-09 | ProgressStepperでステータス表示 | E-03 (ProgressStepper) | ○ |
| C-10 | 一般セクションに顧客、請求日、支払条件がある | E-03 (Section general) | ○ |
| C-11 | タブ構成（明細、その他情報、利用規約） | E-03 (Tabs) | ○ |
| C-12 | 商品Repeaterがある | E-03 (getProductRepeater) | ○ |
| C-13 | InvoiceSummaryコンポーネントで合計表示 | E-03 (Livewire InvoiceSummary) | ○ |
| C-14 | 顧客選択時にフィールドが自動設定される | E-03 (afterStateUpdated partner_id) | ○ |
| C-15 | 商品選択時に単位、単価、税率が設定される | E-03 (afterProductUpdated) | ○ |
| C-16 | 会社選択時に通貨が自動設定される | E-03 (company_id afterStateUpdated) | ○ |
| C-17 | 削除されたレコードは選択不可表示 | E-03 (disableOptionWhen Deleted) | ○ |
| C-18 | ルーティングは'/create' | E-02 (getPages) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] move_typeがOUT_REFUNDで正しく設定されるか確認
- [ ] 商品選択時の自動計算が正しく動作するか確認
- [ ] 保存後の会計計算（computeAccountMove）が正しく実行されるか確認
