---
generated_at: 2025-12-26 12:45:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：160-入庫編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。レビュー優先度は低い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource/Pages/EditReceipt.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `plugins/webkul/inventories/src/Models/Operation.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は「編集」 | E-01 (EditRecord継承) | ○ |
| C-02 | URLは/{record}/edit | E-02 (EditReceipt::route('/{record}/edit')) | ○ |
| C-03 | 保存後は編集画面に留まる | E-01 (getRedirectUrl returns 'edit') | ○ |
| C-04 | HasRecordNavigationTabsを使用 | E-01 (use HasRecordNavigationTabs) | ○ |
| C-05 | HasRepeaterColumnManagerを使用 | E-01 (use HasRepeaterColumnManager) | ○ |
| C-06 | 成功通知を表示 | E-01 (getSavedNotification) | ○ |
| C-07 | チャッターアクションが存在 | E-01 (ChatterAction::make()) | ○ |
| C-08 | ToDoアクションが存在 | E-01 (TodoAction::make()) | ○ |
| C-09 | 検証アクションが存在 | E-01 (ValidateAction::make()) | ○ |
| C-10 | キャンセルアクションが存在 | E-01 (CancelAction::make()) | ○ |
| C-11 | 返品アクションが存在 | E-01 (ReturnAction::make()) | ○ |
| C-12 | 印刷アクションが4種類存在 | E-01 (PickingOperation, DeliverySlip, Package, Labels) | ○ |
| C-13 | 印刷はActionGroupでまとめる | E-01 (ActionGroup::make([Print Actions])) | ○ |
| C-14 | 削除アクションが存在 | E-01 (DeleteAction::make()) | ○ |
| C-15 | 完了済みは削除不可 | E-01 (hidden state == DONE) | ○ |
| C-16 | 削除失敗時はエラー通知 | E-01 (QueryException catch Notification danger) | ○ |
| C-17 | updateFormメソッドが存在 | E-01 (public function updateForm()) | ○ |
| C-18 | サブナビゲーションに3画面 | E-02 (getRecordSubNavigation: ViewReceipt, EditReceipt, ManageMoves) | ○ |
| C-19 | 完了/キャンセル時はフィールド無効 | E-03 (disabled in_array state DONE, CANCELED) | ○ |
| C-20 | quantityは保存済み明細のみ表示 | E-03 (visible state !== DRAFT) | ○ |
| C-21 | 商品選択はドラフト時のみ編集可 | E-03 (product_id disabled state !== DRAFT) | ○ |
| C-22 | 需要数量はドラフト時のみ編集可 | E-03 (product_uom_qty disabled state !== DRAFT) | ○ |
| C-23 | 明細行の詳細管理モーダルが存在 | E-03 (getMoveLinesAction) | ○ |
| C-24 | モーダルでロット作成可能 | E-03 (createOptionForm LotResource::form) | ○ |
| C-25 | モーダルでパッケージ作成可能 | E-03 (createOptionForm PackageResource::form) | ○ |
| C-26 | Repeaterで削除不可（完了/キャンセル時） | E-03 (deletable not in DONE, CANCELED) | ○ |
| C-27 | Repeaterで追加不可（完了/キャンセル時） | E-03 (addable not in DONE, CANCELED) | ○ |
| C-28 | 印刷ボタンの色はgray | E-01 (color('gray')) | ○ |
| C-29 | 印刷ボタンはbutton形式 | E-01 (button()) | ○ |
| C-30 | mutateRelationshipDataBeforeSaveでInventory計算 | E-03 (computeTransferMove, computeTransferState) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 検証アクションで在庫が正しく計上されるか確認
- [ ] キャンセルアクションが正常に動作するか確認
- [ ] 返品アクションで新規オペレーションが作成されるか確認
- [ ] 明細行の詳細管理モーダルが正常に動作するか確認
- [ ] 完了済みオペレーションでフィールドが適切に無効化されるか確認
- [ ] チャッター機能が正常に動作するか確認
