---
generated_at: 2025-12-26 18:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：161-入庫詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **権限による表示制御の詳細**：コード上の権限チェック実装が不明確
  2. **カスケード削除の動作**：データベースマイグレーションファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource/Pages/ViewReceipt.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `plugins/webkul/inventories/src/Models/Receipt.php`
- E-05: `plugins/webkul/inventories/src/Models/Operation.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は詳細表示（ViewRecord） | E-01（ViewRecordクラス継承） | ○ |
| C-02 | ChatterActionが実装されている | E-01（getHeaderActions内） | ○ |
| C-03 | 印刷アクショングループが4種類存在 | E-01（ActionGroup内の4つのアクション） | ○ |
| C-04 | 削除は完了状態以外で可能 | E-01（hidden条件の確認） | ○ |
| C-05 | 削除エラー時にNotificationが表示される | E-01（QueryException catch内） | ○ |
| C-06 | URLパスは/receipts/{record}/view | E-02（getPages定義） | ○ |
| C-07 | サブナビゲーションに3画面が含まれる | E-02（getRecordSubNavigation） | ○ |
| C-08 | モデルはReceiptクラス | E-02（$model定義）, E-04 | ○ |
| C-09 | Receiptは Operationを継承 | E-04, E-05 | ○ |
| C-10 | テーブル名はinventories_operations | E-05（$table定義） | ○ |
| C-11 | infolistはOperationResourceから継承 | E-02（infolist呼び出し） | ○ |
| C-12 | 移動明細表示がRepeatableEntryで実装 | E-03（infolist内） | ○ |
| C-13 | ロケーション表示はWarehouseSettingsで制御 | E-03（visible条件） | ○ |
| C-14 | 単位表示はProductSettingsで制御 | E-03（visible条件） | ○ |
| C-15 | パッケージング表示はProductSettingsで制御 | E-03（visible条件） | ○ |
| C-16 | Operationsクラスターに所属 | E-02（$cluster定義） | ○ |
| C-17 | 権限による詳細な表示制御 | **根拠なし** | △ |
| C-18 | カスケード削除の動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限制御の詳細実装（Policyクラスの確認が必要）
  - 候補：`plugins/webkul/inventories/src/Policies/ReceiptPolicy.php`
- データベースマイグレーションファイル（カスケード削除設定の確認）
  - 候補：`plugins/webkul/inventories/database/migrations/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面表示・ナビゲーションに関する記述
- 1: 中リスク - 削除処理のエラーハンドリング（ユーザー体験に影響）
- 0: 低リスク - 印刷機能（別途印刷Actionクラスの確認が望ましい）

## 6) レビュアーチェックリスト（最小）
- [ ] ViewReceiptクラスのgetHeaderActionsメソッドの実装を確認
- [ ] OperationResourceのinfolistメソッドで表示項目が網羅されているか確認
- [ ] 削除時のカスケード動作についてマイグレーションファイルを確認
- [ ] 言語ファイルでメッセージ内容を確認
