---
generated_at: 2025-12-26 18:22:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：162-廃棄一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **フィルター項目の完全性**：QueryBuilderの全制約の確認が必要
  2. **トレーサビリティ設定の影響**：ロット/シリアル番号カラムの表示条件

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ScrapResource/Pages/ListScraps.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ScrapResource.php`
- E-03: `plugins/webkul/inventories/src/Models/Scrap.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は一覧（ListRecords） | E-01（ListRecordsクラス継承） | ○ |
| C-02 | URLパスは/inventories/operations/scraps | E-02（getPages定義） | ○ |
| C-03 | モデルはScrapクラス | E-02（$model定義）, E-03 | ○ |
| C-04 | テーブル名はinventories_scraps | E-03（$table定義） | ○ |
| C-05 | 参照番号形式はSP/{id} | E-03（updateNameメソッド） | ○ |
| C-06 | 削除は完了状態以外で可能 | E-02（hidden条件の確認） | ○ |
| C-07 | 削除エラー時にNotificationが表示される | E-02（QueryException catch内） | ○ |
| C-08 | 一括削除機能が存在 | E-02（DeleteBulkAction） | ○ |
| C-09 | グループ化機能が5種類存在 | E-02（groupsメソッド） | ○ |
| C-10 | フィルターはスライドオーバー表示 | E-02（filtersTriggerAction） | ○ |
| C-11 | idの降順でソート | E-02（getEloquentQuery） | ○ |
| C-12 | Operationsクラスターに所属 | E-02（$cluster定義） | ○ |
| C-13 | ロケーション表示はWarehouseSettingsで制御 | E-02（visible条件） | ○ |
| C-14 | ロット表示はTraceabilitySettingsで制御 | E-02（visible条件） | ○ |
| C-15 | 全フィルター項目の網羅性 | **一部未確認** | △ |
| C-16 | 完了状態レコードの選択不可 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- QueryBuilderの全制約定義の詳細確認
  - 候補：言語ファイルとの対応確認
- checkIfRecordIsSelectableUsingの実装確認
  - 候補：ScrapResourceのtableメソッド内

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面表示・ナビゲーションに関する記述
- 1: 中リスク - 削除処理のエラーハンドリング
- 0: 低リスク - フィルタリング機能

## 6) レビュアーチェックリスト（最小）
- [ ] ScrapResourceクラスのtableメソッドで全カラム・フィルターが実装されているか確認
- [ ] ListScrapsクラスでPresetViewが定義されているか確認
- [ ] 言語ファイルでメッセージ内容を確認
- [ ] 設定クラス（TraceabilitySettings, WarehouseSettings）の影響を確認
