---
generated_at: 2025-12-26 18:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：166-内部移動一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **プリセットビューの完全性**：全タブが正しく実装されているか確認
  2. **カスケード削除の動作**：データベースマイグレーションファイルの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/InternalResource/Pages/ListInternals.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/InternalResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `plugins/webkul/inventories/src/Models/InternalTransfer.php`
- E-05: `plugins/webkul/inventories/src/Models/Operation.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は一覧（ListRecords） | E-01（ListRecordsクラス継承） | ○ |
| C-02 | URLパスは/inventories/operations/internals | E-02（getPages定義） | ○ |
| C-03 | モデルはInternalTransferクラス | E-02（$model定義）, E-04 | ○ |
| C-04 | InternalTransferはOperationを継承 | E-04, E-05 | ○ |
| C-05 | テーブル名はinventories_operations | E-05（$table定義） | ○ |
| C-06 | OperationType.type = 'internal'でフィルタ | E-02（modifyQueryUsing） | ○ |
| C-07 | 削除は完了状態以外で可能 | E-02（hidden条件の確認） | ○ |
| C-08 | 削除エラー時にNotificationが表示される | E-02（QueryException catch内） | ○ |
| C-09 | 一括削除機能が存在 | E-02（DeleteBulkAction） | ○ |
| C-10 | グループ化機能が5種類存在 | E-03（groupsメソッド） | ○ |
| C-11 | フィルターはスライドオーバー表示 | E-03（filtersTriggerAction） | ○ |
| C-12 | idの降順でソート | E-02（getEloquentQuery） | ○ |
| C-13 | Operationsクラスターに所属 | E-02（$cluster定義） | ○ |
| C-14 | ロケーション表示はWarehouseSettingsで制御 | E-03（visible条件） | ○ |
| C-15 | enable_locationsがtrueの場合のみ表示 | E-02（isDiscovered） | ○ |
| C-16 | プリセットビューが8種類存在 | E-03（getPresetTableViews） | ○ |
| C-17 | お気に入りアイコンで切替可能 | E-03（IconColumn action） | ○ |
| C-18 | テーブル定義はOperationResourceから継承 | E-02（table呼び出し） | ○ |
| C-19 | 全フィルター項目の網羅性 | **一部未確認** | △ |
| C-20 | カスケード削除の動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- QueryBuilderの全制約定義の詳細確認
  - 候補：OperationResource内のfiltersメソッド
- データベースマイグレーションファイル（カスケード削除設定の確認）
  - 候補：`plugins/webkul/inventories/database/migrations/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面表示・ナビゲーションに関する記述
- 1: 中リスク - 削除処理のエラーハンドリング
- 0: 低リスク - プリセットビュー・フィルタリング機能

## 6) レビュアーチェックリスト（最小）
- [ ] InternalResourceクラスのisDiscoveredメソッドでenable_locationsの条件を確認
- [ ] OperationResourceのtableメソッドで全カラム・フィルターが実装されているか確認
- [ ] OperationResourceのgetPresetTableViewsで全プリセットビューが定義されているか確認
- [ ] ListInternalsクラスでPresetViewの継承/オーバーライドを確認
- [ ] 言語ファイルでメッセージ内容を確認
