---
generated_at: 2025-12-26 18:32:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：167-内部移動作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **移動明細作成時のデータ設定**：mutateRelationshipDataBeforeCreateUsingの詳細確認
  2. **オペレーションタイプ選択時の動作**：afterStateUpdatedの実装確認
  3. **伝票番号の自動生成ロジック**：updateNameメソッドの詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/InternalResource/Pages/CreateInternal.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/InternalResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `plugins/webkul/inventories/src/Models/InternalTransfer.php`
- E-05: `plugins/webkul/inventories/src/Models/Operation.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は作成（CreateRecord） | E-01（CreateRecordクラス継承） | ○ |
| C-02 | URLパスは/internals/create | E-02（getPages定義） | ○ |
| C-03 | フォーム定義はOperationResourceから継承 | E-02（form呼び出し） | ○ |
| C-04 | ProgressStepperで状態表示 | E-03（formメソッド内） | ○ |
| C-05 | オペレーションタイプ選択でロケーションが設定される | E-03（afterStateUpdated） | ○ |
| C-06 | 移動明細はRepeaterで実装 | E-03（getMovesRepeater） | ○ |
| C-07 | 商品選択時に単位が自動設定 | E-03（afterProductUpdated） | ○ |
| C-08 | 需要数量変更時にproduct_qtyが計算 | E-03（afterProductUOMQtyUpdated） | ○ |
| C-09 | 状態は'draft'で初期作成 | E-05（fillable, casts） | ○ |
| C-10 | 伝票番号は{warehouse_code}/{operation_type_code}/{id}形式 | E-05（updateNameメソッド） | ○ |
| C-11 | move_typeのデフォルトは'direct' | E-03（formメソッド内） | ○ |
| C-12 | user_idのデフォルトはAuth::id() | E-03（formメソッド内） | ○ |
| C-13 | scheduled_atのデフォルトはnow() | E-03（formメソッド内） | ○ |
| C-14 | 移動明細作成時に追加データが設定される | E-03（mutateRelationshipDataBeforeCreateUsing） | ○ |
| C-15 | 商品選択はGOODSタイプのみ | E-03（formメソッド内） | ○ |
| C-16 | パッケージング表示はProductSettingsで制御 | E-03（visible条件） | ○ |
| C-17 | company_idはdefault_company_idで自動設定 | **実装確認必要** | △ |
| C-18 | creator_idは自動設定 | **実装確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- CreateInternalクラスでのmutateFormDataBeforeCreateの実装有無
  - 候補：CreateInternal.phpでの上書き確認
- バリデーションルールの詳細
  - 候補：FormRequestクラスまたはフォーム定義内
- 会社ID・作成者IDの設定箇所
  - 候補：モデルのbootメソッドまたはCreateRecordのフック

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 移動明細作成時のデータ整合性
- 0: 低リスク - 画面種別・URL・モデル関連の記述
- 0: 低リスク - 設定による表示制御

## 6) レビュアーチェックリスト（最小）
- [ ] CreateInternalクラスでmutateFormDataBeforeCreateが実装されているか確認
- [ ] OperationResourceのgetMovesRepeaterメソッドでmutateRelationshipDataBeforeCreateUsingの内容を確認
- [ ] OperationモデルのupdateNameメソッドで伝票番号生成ロジックを確認
- [ ] 設定クラス（ProductSettings, WarehouseSettings）の影響を確認
- [ ] 言語ファイルでメッセージ内容を確認
