---
generated_at: 2025-12-26 18:34:00
metrics:
  claims_total: 22
  claims_with_evidence: 17
  claims_without_evidence: 5
confidence_derived: 0.77
---

# 根拠レポート：168-内部移動編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.77**
  - 根拠あり：17 / 22、根拠なし：5
- 優先レビュー（高）
  1. **各ワークフローアクションの詳細**：Inventoryファサードの各メソッド実装確認が必要
  2. **在庫更新処理の詳細**：検証時のproduct_quantities更新ロジック確認
  3. **戻り注文作成の詳細**：createReturnメソッドの実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/InternalResource/Pages/EditInternal.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/InternalResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `plugins/webkul/inventories/src/Models/InternalTransfer.php`
- E-05: `plugins/webkul/inventories/src/Models/Operation.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は編集（EditRecord） | E-01（EditRecordクラス継承） | ○ |
| C-02 | URLパスは/internals/{record}/edit | E-02（getPages定義） | ○ |
| C-03 | ChatterActionが実装されている | E-01（getHeaderActions内） | ○ |
| C-04 | 確認ボタンが存在する | E-01（getHeaderActions内） | ○ |
| C-05 | 可用性確認ボタンが存在する | E-01（getHeaderActions内） | ○ |
| C-06 | 検証ボタンが存在する | E-01（getHeaderActions内） | ○ |
| C-07 | 戻りボタンが存在する | E-01（getHeaderActions内） | ○ |
| C-08 | キャンセルボタンが存在する | E-01（getHeaderActions内） | ○ |
| C-09 | 削除ボタンが存在する | E-01（getHeaderActions内） | ○ |
| C-10 | サブナビゲーションが実装されている | E-02（getRecordSubNavigation） | ○ |
| C-11 | フォーム定義はOperationResourceから継承 | E-02（form呼び出し） | ○ |
| C-12 | ProgressStepperで状態表示 | E-03（formメソッド内） | ○ |
| C-13 | 確認処理でInventory::confirmTransferを呼び出す | **実装確認必要** | △ |
| C-14 | 可用性確認でInventory::checkAvailabilityを呼び出す | **実装確認必要** | △ |
| C-15 | 検証処理でInventory::validateTransferを呼び出す | **実装確認必要** | △ |
| C-16 | 戻り作成でInventory::createReturnを呼び出す | **実装確認必要** | △ |
| C-17 | 検証時にclosed_atが設定される | **実装詳細未確認** | △ |
| C-18 | 完了/キャンセル時は全フィールド編集不可 | E-03（disabled条件） | ○ |
| C-19 | 移動明細はRepeaterで実装 | E-03（getMovesRepeater） | ○ |
| C-20 | 状態に応じてRepeaterの追加削除が制御される | E-03（deletable, addable条件） | ○ |
| C-21 | 移動明細更新時にcomputeTransferMoveが呼ばれる | E-03（mutateRelationshipDataBeforeSaveUsing） | ○ |
| C-22 | 移動明細更新時にcomputeTransferStateが呼ばれる | E-03（mutateRelationshipDataBeforeSaveUsing） | ○ |

## 4) 不足情報（Unknown / Missing）
- Inventoryファサードの各ワークフローメソッドの実装詳細
  - 候補：`plugins/webkul/inventories/src/Facades/Inventory.php` または対応するサービスクラス
- EditInternalクラスのgetHeaderActionsメソッドの完全な実装
  - 候補：EditInternal.php内の詳細確認
- 在庫更新処理の詳細（product_quantities テーブルへの影響）
  - 候補：Inventoryサービスクラス内のトランザクション処理

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - 検証処理のビジネスロジック（在庫への影響大）
- 1: 中リスク - 確認・可用性確認処理のビジネスロジック
- 1: 中リスク - 戻り注文作成処理
- 0: 低リスク - 画面表示・ナビゲーションに関する記述

## 6) レビュアーチェックリスト（最小）
- [ ] EditInternalクラスのgetHeaderActionsメソッドで全アクションが実装されているか確認
- [ ] Inventoryファサードの各メソッド（confirmTransfer, checkAvailability, validateTransfer, createReturn）の実装を確認
- [ ] OperationResourceのformメソッドで状態によるdisabled制御を確認
- [ ] getMovesRepeaterで移動明細の更新処理を確認
- [ ] 言語ファイルでメッセージ内容を確認
