---
generated_at: 2025-12-26 18:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-クレジットノート編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/CreditNoteResource/Pages/EditCreditNote.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/CreditNoteResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php`
- E-04: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Pages/EditInvoice.php`
- E-05: `plugins/webkul/accounts/src/Models/Move.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「クレジットノート編集」である | E-06 | ○ |
| C-02 | EditInvoice（EditRecord）を継承している | E-01 | ○ |
| C-03 | リダイレクト先は詳細画面（view） | E-01 (getRedirectUrl) | ○ |
| C-04 | 更新成功通知が表示される | E-01 (getSavedNotification) | ○ |
| C-05 | set-as-checkedとcredit-noteアクションは除外 | E-01 (getHeaderActions filter) | ○ |
| C-06 | プレビューはクレジットノート専用テンプレートを使用 | E-01 (PreviewAction setTemplate) | ○ |
| C-07 | mutateFormDataBeforeSaveで既存値マージ | E-01 (mutateFormDataBeforeSave) | ○ |
| C-08 | afterSaveでAccount::computeAccountMoveが実行 | E-01 (afterSave) | ○ |
| C-09 | 親クラスEditInvoiceにヘッダーアクションがある | E-04 (getHeaderActions) | ○ |
| C-10 | ChatterAction, PayAction, ConfirmAction等がある | E-04 (getHeaderActions) | ○ |
| C-11 | POSTED/CANCEL時は一部フィールドが編集不可 | E-03 (disabled条件) | ○ |
| C-12 | フォームはInvoiceResourceのformを使用 | E-03 (form method) | ○ |
| C-13 | ProgressStepperでステータス表示 | E-03 (ProgressStepper) | ○ |
| C-14 | HasRepeaterColumnManagerトレイトを使用 | E-04 (use HasRepeaterColumnManager) | ○ |
| C-15 | HasRecordNavigationTabsトレイトを使用 | E-04 (use HasRecordNavigationTabs) | ○ |
| C-16 | invoice_currency_rateはデフォルト1.0 | E-01 (mutateFormDataBeforeSave) | ○ |
| C-17 | モデルはAccountMove（Move） | E-02 ($model) | ○ |
| C-18 | ルーティングは'/{record}/edit' | E-02 (getPages) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ヘッダーアクションのフィルタリングが正しく動作するか確認
- [ ] 状態に応じたフィールド編集可否が正しく制御されるか確認
- [ ] 保存後の会計再計算が正しく実行されるか確認
