---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：171-出庫作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **権限による表示制御の詳細**：コード上の具体的な実装が確認できず
  2. **メッセージの国際化キー**：翻訳ファイルの内容は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/DeliveryResource/Pages/CreateDelivery.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/DeliveryResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `plugins/webkul/inventories/src/Models/Operation.php`
- E-05: `plugins/webkul/inventories/src/Models/Delivery.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/inventories/operations/deliveries/create` | E-02 (getPages: CreateDelivery::route('/create')) | ○ |
| C-02 | CreateDeliveryクラスがCreateRecordを継承 | E-01 (class CreateDelivery extends CreateRecord) | ○ |
| C-03 | デフォルトでOUTGOINGタイプのオペレーションタイプが設定される | E-01 (mount: OperationType::where('type', Enums\OperationType::OUTGOING)) | ○ |
| C-04 | 作成後は編集画面にリダイレクト | E-01 (getRedirectUrl: getResource()::getUrl('edit')) | ○ |
| C-05 | stateはDRAFTで初期化される | E-01 (mutateFormDataBeforeCreate: OperationState::DRAFT) | ○ |
| C-06 | creator_idにはAuth::id()が設定される | E-01 (mutateFormDataBeforeCreate: $data['creator_id'] = Auth::id()) | ○ |
| C-07 | フォームはOperationResourceから共有される | E-02 (form: OperationResource::form($schema)) | ○ |
| C-08 | テーブルはOperationResourceから共有される | E-02 (table: OperationResource::table($table)) | ○ |
| C-09 | infolistはOperationResourceから共有される | E-02 (infolist: OperationResource::infolist($schema)) | ○ |
| C-10 | 配送先フィールドはOUTGOINGタイプ時に表示 | E-03 (visible: OperationType::OUTGOING) | ○ |
| C-11 | ソースロケーションはINTERNAL/OUTGOING時に表示 | E-03 (visible: type != INCOMING) | ○ |
| C-12 | 商品選択時にUOMが自動設定される | E-03 (afterProductUpdated: set('uom_id', $product->uom_id)) | ○ |
| C-13 | 商品選択時にパッケージングが自動選択される | E-03 (afterProductUpdated: getBestPackaging) | ○ |
| C-14 | Repeaterで複数商品を追加可能 | E-03 (getMovesRepeater: Repeater::make('moves')) | ○ |
| C-15 | DONE/CANCELEDの場合はフィールドが無効化 | E-03 (disabled: in_array($record?->state, [OperationState::DONE, OperationState::CANCELED])) | ○ |
| C-16 | inventories_operationsテーブルに保存 | E-04 (protected $table = 'inventories_operations') | ○ |
| C-17 | DeliveryモデルはOperationを継承 | E-05 (class Delivery extends Operation) | ○ |
| C-18 | nameは自動生成される | E-04 (updateName: シーケンスコード + ID) | ○ |
| C-19 | 画面No.171は出庫作成画面 | E-06 (No.171, 出庫作成) | ○ |
| C-20 | 機能FN-INV-007は出荷作成 | E-07 (FN-INV-007, 出荷作成) | ○ |
| C-21 | move_typeはDIRECTがデフォルト | E-03 (default: MoveType::DIRECT) | ○ |
| C-22 | user_idのデフォルトはログインユーザー | E-03 (default: Auth::id()) | ○ |
| C-23 | scheduled_atのデフォルトは現在時刻 | E-03 (default: now()->format('Y-m-d H:i:s')) | ○ |
| C-24 | 権限による表示制御がある | **根拠なし** | △ |
| C-25 | 国際化されたメッセージが使用される | E-01 (__('inventories::...')) | △ |

## 4) 不足情報（Unknown / Missing）
- 権限制御の具体的な実装（Policyクラスの確認が必要）
  - 候補：`app/Policies/DeliveryPolicy.php` / Filament Resource権限設定
- 翻訳ファイルの内容確認
  - 候補：`plugins/webkul/inventories/lang/` 配下のファイル

## 5) リスクフラグ（レビュー観点）
- 0: 画面構成・フォーム項目の記述（コードと整合）
- 0: データベース更新仕様（モデル定義と整合）
- 1: 権限制御の詳細（要確認）
- 0: イベント処理フロー（コードと整合）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御の実装を確認（PolicyまたはFilament Resource設定）
- [ ] 翻訳ファイルのキーと内容を確認
- [ ] 実際の画面動作と設計書の整合性を確認
